/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.football.internal;

import java.util.List;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.FlushFailedException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.sample.domain.football.PlayerSummary;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcPlayerSummaryDao
extends SimpleJdbcDaoSupport
implements ItemWriter<PlayerSummary> {
    private static final String INSERT_SUMMARY = "INSERT into PLAYER_SUMMARY(ID, YEAR_NO, COMPLETES, ATTEMPTS, PASSING_YARDS, PASSING_TD, INTERCEPTIONS, RUSHES, RUSH_YARDS, RECEPTIONS, RECEPTIONS_YARDS, TOTAL_TD) values(:id, :year, :completes, :attempts, :passingYards, :passingTd, :interceptions, :rushes, :rushYards, :receptions, :receptionYards, :totalTd)";

    public void write(List<? extends PlayerSummary> summaries) {
        for (PlayerSummary playerSummary : summaries) {
            MapSqlParameterSource args = new MapSqlParameterSource().addValue("id", (Object)playerSummary.getId()).addValue("year", (Object)playerSummary.getYear()).addValue("completes", (Object)playerSummary.getCompletes()).addValue("attempts", (Object)playerSummary.getAttempts()).addValue("passingYards", (Object)playerSummary.getPassingYards()).addValue("passingTd", (Object)playerSummary.getPassingTd()).addValue("interceptions", (Object)playerSummary.getInterceptions()).addValue("rushes", (Object)playerSummary.getRushes()).addValue("rushYards", (Object)playerSummary.getRushYards()).addValue("receptions", (Object)playerSummary.getReceptions()).addValue("receptionYards", (Object)playerSummary.getReceptionYards()).addValue("totalTd", (Object)playerSummary.getTotalTd());
            this.getSimpleJdbcTemplate().update(INSERT_SUMMARY, (SqlParameterSource)args);
        }
    }

    public void close() throws Exception {
    }

    public void clear() throws ClearFailedException {
    }

    public void flush() throws FlushFailedException {
    }
}

