/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.multiline;

import org.springframework.batch.item.ItemReaderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateItem<T> {
    private static final AggregateItem FOOTER = new AggregateItem<Object>(false, true){

        @Override
        public Object getItem() throws ItemReaderException {
            throw new IllegalStateException("Footer record has no item.");
        }
    };
    private static final AggregateItem HEADER = new AggregateItem<Object>(true, false){

        @Override
        public Object getItem() throws ItemReaderException {
            throw new IllegalStateException("Header record has no item.");
        }
    };
    private T item;
    private boolean footer = false;
    private boolean header = false;

    public static final <T> AggregateItem<T> getFooter() {
        return FOOTER;
    }

    public static final <T> AggregateItem<T> getHeader() {
        return HEADER;
    }

    public AggregateItem(T item) {
        this.item = item;
    }

    public AggregateItem(boolean header, boolean footer) {
        this(null);
        this.header = header;
        this.footer = footer;
    }

    public T getItem() throws IllegalStateException {
        return this.item;
    }

    public boolean isFooter() {
        return this.footer;
    }

    public boolean isHeader() {
        return this.header;
    }
}

