/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.multiline;

import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.sample.domain.multiline.AggregateItem;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateItemFieldSetMapper<T>
implements FieldSetMapper<AggregateItem<T>>,
InitializingBean {
    private FieldSetMapper<T> delegate;
    private String end = "END";
    private String begin = "BEGIN";

    public void setDelegate(FieldSetMapper<T> delegate) {
        this.delegate = delegate;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public void setBegin(String begin) {
        this.begin = begin;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegate, (String)"A FieldSetMapper delegate must be provided.");
    }

    public AggregateItem<T> mapFieldSet(FieldSet fieldSet) {
        if (fieldSet.readString(0).equals(this.begin)) {
            return AggregateItem.getHeader();
        }
        if (fieldSet.readString(0).equals(this.end)) {
            return AggregateItem.getFooter();
        }
        return new AggregateItem<Object>(this.delegate.mapFieldSet(fieldSet));
    }
}

