/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.multiline;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.sample.domain.multiline.AggregateItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateItemReader<T>
implements ItemReader<List<T>> {
    private static final Log log = LogFactory.getLog(AggregateItemReader.class);
    private ItemReader<AggregateItem<T>> itemReader;

    public List<T> read() throws Exception {
        ResultHolder holder = new ResultHolder();
        while (this.process((AggregateItem)this.itemReader.read(), holder)) {
        }
        if (!holder.exhausted) {
            return holder.records;
        }
        return null;
    }

    private boolean process(AggregateItem<T> value, ResultHolder holder) {
        if (value == null) {
            log.debug((Object)"Exhausted ItemReader");
            holder.exhausted = true;
            return false;
        }
        if (value.isHeader()) {
            log.debug((Object)"Start of new record detected");
            return true;
        }
        if (value.isFooter()) {
            log.debug((Object)"End of record detected");
            return false;
        }
        log.debug((Object)("Mapping: " + value));
        holder.records.add(value.getItem());
        return true;
    }

    public void setItemReader(ItemReader<AggregateItem<T>> itemReader) {
        this.itemReader = itemReader;
    }

    private class ResultHolder {
        List<T> records = new ArrayList();
        boolean exhausted = false;

        private ResultHolder() {
        }
    }
}

