/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.order.internal;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.sample.domain.order.Address;
import org.springframework.batch.sample.domain.order.BillingInfo;
import org.springframework.batch.sample.domain.order.Customer;
import org.springframework.batch.sample.domain.order.LineItem;
import org.springframework.batch.sample.domain.order.Order;
import org.springframework.batch.sample.domain.order.ShippingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderItemReader
implements ItemReader<Order> {
    private static Log log = LogFactory.getLog(OrderItemReader.class);
    private Order order;
    private boolean recordFinished;
    private FieldSetMapper<Order> headerMapper;
    private FieldSetMapper<Customer> customerMapper;
    private FieldSetMapper<Address> addressMapper;
    private FieldSetMapper<BillingInfo> billingMapper;
    private FieldSetMapper<LineItem> itemMapper;
    private FieldSetMapper<ShippingInfo> shippingMapper;
    private ItemReader<FieldSet> fieldSetReader;

    public Order read() throws Exception {
        this.recordFinished = false;
        while (!this.recordFinished) {
            this.process((FieldSet)this.fieldSetReader.read());
        }
        log.info((Object)("Mapped: " + this.order));
        Order result = this.order;
        this.order = null;
        return result;
    }

    private void process(FieldSet fieldSet) throws Exception {
        if (fieldSet == null) {
            log.debug((Object)"FINISHED");
            this.recordFinished = true;
            this.order = null;
            return;
        }
        String lineId = fieldSet.readString(0);
        if ("HEA".equals(lineId)) {
            log.debug((Object)"STARTING NEW RECORD");
            this.order = (Order)this.headerMapper.mapFieldSet(fieldSet);
            return;
        }
        if ("FOT".equals(lineId)) {
            log.debug((Object)"END OF RECORD");
            this.order.setTotalPrice(fieldSet.readBigDecimal("TOTAL_PRICE"));
            this.order.setTotalLines(fieldSet.readInt("TOTAL_LINE_ITEMS"));
            this.order.setTotalItems(fieldSet.readInt("TOTAL_ITEMS"));
            this.recordFinished = true;
            return;
        }
        if ("BCU".equals(lineId)) {
            log.debug((Object)"MAPPING CUSTOMER");
            if (this.order.getCustomer() == null) {
                this.order.setCustomer((Customer)this.customerMapper.mapFieldSet(fieldSet));
                this.order.getCustomer().setBusinessCustomer(true);
            }
            return;
        }
        if ("NCU".equals(lineId)) {
            log.debug((Object)"MAPPING CUSTOMER");
            if (this.order.getCustomer() == null) {
                this.order.setCustomer((Customer)this.customerMapper.mapFieldSet(fieldSet));
                this.order.getCustomer().setBusinessCustomer(false);
            }
            return;
        }
        if ("BAD".equals(lineId)) {
            log.debug((Object)"MAPPING BILLING ADDRESS");
            this.order.setBillingAddress((Address)this.addressMapper.mapFieldSet(fieldSet));
            return;
        }
        if ("SAD".equals(lineId)) {
            log.debug((Object)"MAPPING SHIPPING ADDRESS");
            this.order.setShippingAddress((Address)this.addressMapper.mapFieldSet(fieldSet));
            return;
        }
        if ("BIN".equals(lineId)) {
            log.debug((Object)"MAPPING BILLING INFO");
            this.order.setBilling((BillingInfo)this.billingMapper.mapFieldSet(fieldSet));
            return;
        }
        if ("SIN".equals(lineId)) {
            log.debug((Object)"MAPPING SHIPPING INFO");
            this.order.setShipping((ShippingInfo)this.shippingMapper.mapFieldSet(fieldSet));
            return;
        }
        if ("LIT".equals(lineId)) {
            log.debug((Object)"MAPPING LINE ITEM");
            if (this.order.getLineItems() == null) {
                this.order.setLineItems(new ArrayList<LineItem>());
            }
            this.order.getLineItems().add((LineItem)this.itemMapper.mapFieldSet(fieldSet));
            return;
        }
        log.debug((Object)("Could not map LINE_ID=" + lineId));
    }

    public void setFieldSetReader(ItemReader<FieldSet> fieldSetReader) {
        this.fieldSetReader = fieldSetReader;
    }

    public void setAddressMapper(FieldSetMapper<Address> addressMapper) {
        this.addressMapper = addressMapper;
    }

    public void setBillingMapper(FieldSetMapper<BillingInfo> billingMapper) {
        this.billingMapper = billingMapper;
    }

    public void setCustomerMapper(FieldSetMapper<Customer> customerMapper) {
        this.customerMapper = customerMapper;
    }

    public void setHeaderMapper(FieldSetMapper<Order> headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setItemMapper(FieldSetMapper<LineItem> itemMapper) {
        this.itemMapper = itemMapper;
    }

    public void setShippingMapper(FieldSetMapper<ShippingInfo> shippingMapper) {
        this.shippingMapper = shippingMapper;
    }
}

