/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.order.internal;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.sample.domain.order.Address;
import org.springframework.batch.sample.domain.order.BillingInfo;
import org.springframework.batch.sample.domain.order.Customer;
import org.springframework.batch.sample.domain.order.LineItem;
import org.springframework.batch.sample.domain.order.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderProcessor
implements ItemProcessor<Order, List<String>> {
    private Map<String, LineAggregator<Object[]>> aggregators;

    public List<String> process(Order order) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getAggregator("header").aggregate((Object)OrderFormatterUtils.headerArgs(order)));
        result.add(this.getAggregator("customer").aggregate((Object)OrderFormatterUtils.customerArgs(order)));
        result.add(this.getAggregator("address").aggregate((Object)OrderFormatterUtils.billingAddressArgs(order)));
        result.add(this.getAggregator("billing").aggregate((Object)OrderFormatterUtils.billingInfoArgs(order)));
        List<LineItem> items = order.getLineItems();
        for (LineItem lineItem : items) {
            result.add(this.getAggregator("item").aggregate((Object)OrderFormatterUtils.lineItemArgs(lineItem)));
        }
        result.add(this.getAggregator("footer").aggregate((Object)OrderFormatterUtils.footerArgs(order)));
        return result;
    }

    public void setAggregators(Map<String, LineAggregator<Object[]>> aggregators) {
        this.aggregators = aggregators;
    }

    private LineAggregator<Object[]> getAggregator(String name) {
        return this.aggregators.get(name);
    }

    private static class OrderFormatterUtils {
        private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");

        private OrderFormatterUtils() {
        }

        static Object[] headerArgs(Order order) {
            return new Object[]{"BEGIN_ORDER:", String.valueOf(order.getOrderId()), dateFormat.format(order.getOrderDate())};
        }

        static Object[] footerArgs(Order order) {
            return new Object[]{"END_ORDER:", order.getTotalPrice().toString()};
        }

        static Object[] customerArgs(Order order) {
            Customer customer = order.getCustomer();
            return new Object[]{"CUSTOMER:", String.valueOf(customer.getRegistrationId()), customer.getFirstName(), customer.getMiddleName(), customer.getLastName()};
        }

        static Object[] lineItemArgs(LineItem item) {
            return new Object[]{"ITEM:", String.valueOf(item.getItemId()), item.getPrice().toString()};
        }

        static Object[] billingAddressArgs(Order order) {
            Address address = order.getBillingAddress();
            return new Object[]{"ADDRESS:", address.getAddrLine1(), address.getCity(), address.getZipCode()};
        }

        static Object[] billingInfoArgs(Order order) {
            BillingInfo billingInfo = order.getBilling();
            return new Object[]{"BILLING:", billingInfo.getPaymentId(), billingInfo.getPaymentDesc()};
        }
    }
}

