/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.order.internal.valang;

import java.util.List;
import org.springframework.batch.sample.domain.order.LineItem;
import org.springmodules.validation.valang.functions.AbstractFunction;
import org.springmodules.validation.valang.functions.Function;

public class TotalOrderItemsFunction
extends AbstractFunction {
    public TotalOrderItemsFunction(Function[] arguments, int line, int column) {
        super(arguments, line, column);
        this.definedExactNumberOfArguments(2);
    }

    protected Object doGetResult(Object target) throws Exception {
        int totalItems;
        int count = (Integer)this.getArguments()[0].getResult(target);
        Object value = this.getArguments()[1].getResult(target);
        if (value instanceof List) {
            totalItems = 0;
            for (LineItem lineItem : (List)value) {
                totalItems += lineItem.getQuantity();
            }
        } else {
            throw new Exception("No list for validation");
        }
        Boolean result = totalItems == count ? Boolean.TRUE : Boolean.FALSE;
        return result;
    }
}

