/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.order.internal.valang;

import java.math.BigDecimal;
import java.util.List;
import org.springframework.batch.sample.domain.order.LineItem;
import org.springmodules.validation.valang.functions.AbstractFunction;
import org.springmodules.validation.valang.functions.Function;

public class ValidateHandlingPricesFunction
extends AbstractFunction {
    private static final BigDecimal BD_MIN = new BigDecimal(0.0);
    private static final BigDecimal BD_MAX = new BigDecimal(9.999999999E7);

    public ValidateHandlingPricesFunction(Function[] arguments, int line, int column) {
        super(arguments, line, column);
        this.definedExactNumberOfArguments(1);
    }

    protected Object doGetResult(Object target) throws Exception {
        List lineItems = (List)this.getArguments()[0].getResult(target);
        for (LineItem item : lineItems) {
            if (BD_MIN.compareTo(item.getHandlingPrice()) <= 0 && BD_MAX.compareTo(item.getHandlingPrice()) >= 0) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

