/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.order.internal.valang;

import java.math.BigDecimal;
import java.util.List;
import org.springframework.batch.sample.domain.order.LineItem;
import org.springmodules.validation.valang.functions.AbstractFunction;
import org.springmodules.validation.valang.functions.Function;

public class ValidateTotalPricesFunction
extends AbstractFunction {
    private static final BigDecimal BD_MIN = new BigDecimal(0.0);
    private static final BigDecimal BD_MAX = new BigDecimal(9.999999999E7);
    private static final BigDecimal BD_100 = new BigDecimal(100.0);

    public ValidateTotalPricesFunction(Function[] arguments, int line, int column) {
        super(arguments, line, column);
        this.definedExactNumberOfArguments(1);
    }

    protected Object doGetResult(Object target) throws Exception {
        List lineItems = (List)this.getArguments()[0].getResult(target);
        for (LineItem item : lineItems) {
            BigDecimal quantity;
            if (BD_MIN.compareTo(item.getTotalPrice()) > 0 || BD_MAX.compareTo(item.getTotalPrice()) < 0) {
                return Boolean.FALSE;
            }
            BigDecimal coef = BD_100.subtract(item.getDiscountPerc()).divide(BD_100, 4, 4);
            BigDecimal discountedPrice = item.getPrice().multiply(coef).subtract(item.getDiscountAmount());
            BigDecimal singleItemPrice = discountedPrice.add(item.getShippingPrice()).add(item.getHandlingPrice());
            BigDecimal totalPrice = singleItemPrice.multiply(quantity = new BigDecimal(item.getQuantity())).setScale(2, 4);
            if (totalPrice.compareTo(item.getTotalPrice()) == 0) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

