/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.trade;

import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.transform.LineTokenizer;

public class CompositeCustomerUpdateLineTokenizer
extends StepExecutionListenerSupport
implements LineTokenizer {
    private LineTokenizer customerTokenizer;
    private LineTokenizer footerTokenizer;
    private StepExecution stepExecution;

    public FieldSet tokenize(String line) {
        if (line.charAt(0) == 'F') {
            long fileUpdateTotal;
            FieldSet fs = this.footerTokenizer.tokenize(line);
            long customerUpdateTotal = this.stepExecution.getReadCount();
            if (customerUpdateTotal != (fileUpdateTotal = fs.readLong(1))) {
                throw new IllegalStateException("The total number of customer updates in the file footer does not match the number entered  File footer total: [" + fileUpdateTotal + "] Total encountered during processing: [" + customerUpdateTotal + "]");
            }
            return null;
        }
        if (line.charAt(0) == 'A' || line.charAt(0) == 'U' || line.charAt(0) == 'D') {
            return this.customerTokenizer.tokenize(line);
        }
        throw new IllegalArgumentException("Invalid line encountered for tokenizing: " + line);
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void setCustomerTokenizer(LineTokenizer customerTokenizer) {
        this.customerTokenizer = customerTokenizer;
    }

    public void setFooterTokenizer(LineTokenizer footerTokenizer) {
        this.footerTokenizer = footerTokenizer;
    }
}

