/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.trade;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CustomerOperation {
    ADD('A'),
    UPDATE('U'),
    DELETE('D');

    private final char code;
    private static final Map<Character, CustomerOperation> codeMap;

    private CustomerOperation(char code) {
        this.code = code;
    }

    public static CustomerOperation fromCode(char code) {
        if (codeMap.containsKey(Character.valueOf(code))) {
            return codeMap.get(Character.valueOf(code));
        }
        throw new IllegalArgumentException("Invalid code: [" + code + "]");
    }

    public char getCode() {
        return this.code;
    }

    static {
        codeMap = new HashMap<Character, CustomerOperation>();
        for (CustomerOperation operation : CustomerOperation.values()) {
            codeMap.put(Character.valueOf(operation.getCode()), operation);
        }
    }
}

