/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.trade;

import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.sample.domain.trade.CustomerCredit;
import org.springframework.batch.sample.domain.trade.CustomerDao;
import org.springframework.batch.sample.domain.trade.CustomerOperation;
import org.springframework.batch.sample.domain.trade.CustomerUpdate;
import org.springframework.batch.sample.domain.trade.InvalidCustomerLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerUpdateProcessor
implements ItemProcessor<CustomerUpdate, CustomerUpdate> {
    private CustomerDao customerDao;
    private InvalidCustomerLogger invalidCustomerLogger;

    public CustomerUpdate process(CustomerUpdate item) throws Exception {
        if (item.getOperation() == CustomerOperation.DELETE) {
            this.invalidCustomerLogger.log(item);
            return null;
        }
        CustomerCredit customerCredit = this.customerDao.getCustomerByName(item.getCustomerName());
        if (item.getOperation() == CustomerOperation.ADD && customerCredit == null) {
            return item;
        }
        if (item.getOperation() == CustomerOperation.ADD && customerCredit != null) {
            this.invalidCustomerLogger.log(item);
            return null;
        }
        if (item.getOperation() == CustomerOperation.UPDATE && customerCredit != null) {
            return item;
        }
        if (item.getOperation() == CustomerOperation.UPDATE && customerCredit == null) {
            this.invalidCustomerLogger.log(item);
            return null;
        }
        this.invalidCustomerLogger.log(item);
        return null;
    }

    public void setCustomerDao(CustomerDao customerDao) {
        this.customerDao = customerDao;
    }

    public void setInvalidCustomerLogger(InvalidCustomerLogger invalidCustomerLogger) {
        this.invalidCustomerLogger = invalidCustomerLogger;
    }
}

