/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.trade;

import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.sample.domain.trade.CustomerDao;
import org.springframework.batch.sample.domain.trade.CustomerOperation;
import org.springframework.batch.sample.domain.trade.CustomerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerUpdateWriter
implements ItemWriter<CustomerUpdate> {
    private CustomerDao customerDao;

    public void write(List<? extends CustomerUpdate> items) throws Exception {
        for (CustomerUpdate customerUpdate : items) {
            if (customerUpdate.getOperation() == CustomerOperation.ADD) {
                this.customerDao.insertCustomer(customerUpdate.getCustomerName(), customerUpdate.getCredit());
                continue;
            }
            if (customerUpdate.getOperation() != CustomerOperation.UPDATE) continue;
            this.customerDao.updateCustomer(customerUpdate.getCustomerName(), customerUpdate.getCredit());
        }
    }

    public void setCustomerDao(CustomerDao customerDao) {
        this.customerDao = customerDao;
    }
}

