/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.trade.internal;

import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.sample.domain.trade.CustomerCredit;
import org.springframework.batch.sample.domain.trade.CustomerCreditDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerCreditUpdateWriter
implements ItemWriter<CustomerCredit> {
    private double creditFilter = 800.0;
    private CustomerCreditDao dao;

    public void write(List<? extends CustomerCredit> customerCredits) throws Exception {
        for (CustomerCredit customerCredit : customerCredits) {
            if (!(customerCredit.getCredit().doubleValue() > this.creditFilter)) continue;
            this.dao.writeCredit(customerCredit);
        }
    }

    public void setCreditFilter(double creditFilter) {
        this.creditFilter = creditFilter;
    }

    public void setDao(CustomerCreditDao dao) {
        this.dao = dao;
    }
}

