/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.trade.internal;

import java.util.List;
import org.hibernate.SessionFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.sample.domain.trade.CustomerCredit;
import org.springframework.batch.sample.domain.trade.CustomerCreditDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.hibernate3.HibernateOperations;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateAwareCustomerCreditItemWriter
implements ItemWriter<CustomerCredit>,
InitializingBean {
    private CustomerCreditDao dao;
    private HibernateOperations hibernateTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<? extends CustomerCredit> items) throws Exception {
        for (CustomerCredit customerCredit : items) {
            this.dao.writeCredit(customerCredit);
        }
        try {
            this.hibernateTemplate.flush();
        }
        finally {
            this.hibernateTemplate.clear();
        }
    }

    public void setDao(CustomerCreditDao dao) {
        this.dao = dao;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.hibernateTemplate = new HibernateTemplate(sessionFactory);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.hibernateTemplate, (String)"Hibernate session factory must be set");
        Assert.notNull((Object)this.dao, (String)"Delegate DAO must be set");
    }
}

