/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.trade.internal;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.batch.sample.domain.trade.CustomerCredit;
import org.springframework.batch.sample.domain.trade.CustomerDao;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class JdbcCustomerDao
extends JdbcDaoSupport
implements CustomerDao {
    private static final String GET_CUSTOMER_BY_NAME = "SELECT ID, NAME, CREDIT from CUSTOMER where NAME = ?";
    private static final String INSERT_CUSTOMER = "INSERT into CUSTOMER(NAME, CREDIT) values(?,?)";
    private static final String UPDATE_CUSTOMER = "UPDATE CUSTOMER set CREDIT = ? where NAME = ?";

    public CustomerCredit getCustomerByName(String name) {
        List customers = this.getJdbcTemplate().query(GET_CUSTOMER_BY_NAME, new Object[]{name}, new RowMapper(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                CustomerCredit customer = new CustomerCredit();
                customer.setName(rs.getString("NAME"));
                customer.setId(rs.getInt("ID"));
                customer.setCredit(rs.getBigDecimal("CREDIT"));
                return customer;
            }
        });
        if (customers.size() == 0) {
            return null;
        }
        return (CustomerCredit)customers.get(0);
    }

    public void insertCustomer(String name, BigDecimal credit) {
        this.getJdbcTemplate().update(INSERT_CUSTOMER, new Object[]{name, credit});
    }

    public void updateCustomer(String name, BigDecimal credit) {
        this.getJdbcTemplate().update(UPDATE_CUSTOMER, new Object[]{credit, name});
    }
}

