/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.trade.internal;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.sample.domain.trade.Trade;
import org.springframework.batch.sample.domain.trade.TradeDao;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class JdbcTradeDao
implements TradeDao {
    private Log log = LogFactory.getLog(JdbcTradeDao.class);
    private static final String INSERT_TRADE_RECORD = "INSERT INTO trade (id, isin, quantity, price, customer) VALUES (?, ?, ? ,?, ?)";
    private SimpleJdbcTemplate simpleJdbcTemplate;
    private DataFieldMaxValueIncrementer incrementer;

    public void writeTrade(Trade trade) {
        Long id = this.incrementer.nextLongValue();
        this.log.debug((Object)("Processing: " + trade));
        this.simpleJdbcTemplate.update(INSERT_TRADE_RECORD, new Object[]{id, trade.getIsin(), trade.getQuantity(), trade.getPrice(), trade.getCustomer()});
    }

    public void setDataSource(DataSource dataSource) {
        this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public void setIncrementer(DataFieldMaxValueIncrementer incrementer) {
        this.incrementer = incrementer;
    }
}

