/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.trade.internal;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.sample.domain.trade.Trade;
import org.springframework.batch.sample.domain.trade.TradeDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TradeWriter
implements ItemWriter<Trade> {
    private static Log log = LogFactory.getLog(TradeWriter.class);
    private TradeDao dao;
    private int failure = -1;
    private int index = 0;

    public void setFailure(int failure) {
        this.failure = failure;
    }

    public void write(List<? extends Trade> trades) {
        for (Trade trade : trades) {
            log.debug((Object)trade);
            this.dao.writeTrade(trade);
            if (this.index++ != this.failure) continue;
            throw new RuntimeException("Something unexpected happened!");
        }
    }

    public void setDao(TradeDao dao) {
        this.dao = dao;
    }
}

