/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.jmx;

import javax.management.Notification;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.sample.jmx.SimpleMessageApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.jmx.export.notification.NotificationPublisher;
import org.springframework.jmx.export.notification.NotificationPublisherAware;

public class JobExecutionNotificationPublisher
implements ApplicationListener,
NotificationPublisherAware {
    protected static final Log logger = LogFactory.getLog(JobExecutionNotificationPublisher.class);
    private NotificationPublisher notificationPublisher;
    private int notificationCount = 0;

    public void setNotificationPublisher(NotificationPublisher notificationPublisher) {
        this.notificationPublisher = notificationPublisher;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof SimpleMessageApplicationEvent) {
            String message = applicationEvent.toString();
            logger.info((Object)message);
            this.publish(message);
        }
    }

    private void publish(String message) {
        if (this.notificationPublisher != null) {
            Notification notification = new Notification("JobExecutionApplicationEvent", (Object)this, (long)this.notificationCount++, message);
            notification.setSource(null);
            this.notificationPublisher.sendNotification(notification);
        }
    }
}

