/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.jmx;

import org.aspectj.lang.JoinPoint;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.sample.jmx.SimpleMessageApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class StepExecutionApplicationEventAdvice
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void before(JoinPoint jp, StepExecution stepExecution) {
        String msg = "Before: " + jp.toShortString() + " with: " + stepExecution;
        this.publish(jp.getTarget(), msg);
    }

    public void after(JoinPoint jp, StepExecution stepExecution) {
        String msg = "After: " + jp.toShortString() + " with: " + stepExecution;
        this.publish(jp.getTarget(), msg);
    }

    public void onError(JoinPoint jp, StepExecution stepExecution, Throwable t) {
        String msg = "Error in: " + jp.toShortString() + " with: " + stepExecution + " (" + t.getClass() + ":" + t.getMessage() + ")";
        this.publish(jp.getTarget(), msg);
    }

    private void publish(Object source, String message) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SimpleMessageApplicationEvent(source, message));
    }
}

