/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.launch;

import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.ListableJobRegistry;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.sample.launch.JobLoader;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJobLoader
implements JobLoader,
ApplicationContextAware {
    private ListableJobRegistry registry;
    private ApplicationContext applicationContext;
    private Map<String, String> configurations = new HashMap<String, String>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setRegistry(ListableJobRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Map<String, String> getConfigurations() {
        HashMap<String, String> result = new HashMap<String, String>(this.configurations);
        for (String jobName : this.registry.getJobNames()) {
            try {
                Job configuration = this.registry.getJob(jobName);
                String name = configuration.getName();
                if (this.configurations.containsKey(name)) continue;
                result.put(name, "<unknown path>: " + configuration);
            }
            catch (NoSuchJobException e) {
                throw new IllegalStateException("Registry could not locate its own job (NoSuchJobException).");
            }
        }
        return result;
    }

    @Override
    public void loadResource(String path) {
        String[] names;
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{path}, this.applicationContext);
        for (String name : names = context.getBeanNamesForType(Job.class)) {
            this.configurations.put(name, path);
        }
    }

    @Override
    public Object getJobConfiguration(String name) {
        try {
            return this.registry.getJob(name);
        }
        catch (NoSuchJobException e) {
            return null;
        }
    }

    @Override
    public Object getProperty(String path) {
        int index = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)path);
        BeanWrapperImpl wrapper = this.createBeanWrapper(path, index);
        String key = path.substring(index + 1);
        return wrapper.getPropertyValue(key);
    }

    @Override
    public void setProperty(String path, String value) {
        int index = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)path);
        BeanWrapperImpl wrapper = this.createBeanWrapper(path, index);
        String key = path.substring(index + 1);
        wrapper.setPropertyValue(key, (Object)value);
    }

    private BeanWrapperImpl createBeanWrapper(String path, int index) {
        Assert.state((index > 0 ? 1 : 0) != 0, (String)"Path must be nested, e.g. bean.value");
        String name = path.substring(0, index);
        Object bean = this.getJobConfiguration(name);
        Assert.notNull((Object)bean, (String)("No JobConfiguration exists with name=" + name));
        return new BeanWrapperImpl(bean);
    }
}

