/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.support;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.ItemWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemTrackingItemWriter<T>
implements ItemWriter<T> {
    private List<T> items = new ArrayList<T>();
    private T failed = null;
    private int failure = -1;
    private int counter = 0;

    public void write(List<? extends T> items) throws Exception {
        if (this.failed != null && items.contains(this.failed)) {
            throw new RuntimeException("write failed again");
        }
        this.items.addAll(items);
        int current = this.counter;
        this.counter += items.size();
        if (current < this.failure && this.counter >= this.failure) {
            this.failed = items.get(this.failure - current - 1);
            this.items.remove(this.failed);
            throw new RuntimeException("write failed");
        }
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setWriteFailure(int failure) {
        this.failure = failure;
    }
}

