/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.tasklet;

import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.AttributeAccessor;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class FileDeletingTasklet
implements Tasklet,
InitializingBean {
    private Resource[] resources;

    public ExitStatus execute(StepContribution contribution, AttributeAccessor attributes) throws Exception {
        for (Resource resource : this.resources) {
            boolean deleted = resource.getFile().delete();
            if (deleted) continue;
            throw new UnexpectedJobExecutionException("Could not delete file " + resource);
        }
        return ExitStatus.FINISHED;
    }

    public void setResources(Resource[] resources) {
        this.resources = resources;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resources, (String)"Resources must be set");
    }
}

