/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.mvc;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.cloud.function.web.mvc.FunctionController;
import org.springframework.cloud.function.web.util.FunctionWebUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ConditionalOnClass(value={RequestMappingHandlerMapping.class})
public class FunctionHandlerMapping
extends RequestMappingHandlerMapping
implements InitializingBean {
    private final FunctionCatalog functions;
    private final FunctionController controller;
    @Value(value="${spring.cloud.function.web.path:}")
    private String prefix = "";

    @Autowired
    public FunctionHandlerMapping(FunctionCatalog catalog, FunctionController controller) {
        this.functions = catalog;
        this.logger.info((Object)("FunctionCatalog: " + catalog));
        this.setOrder(super.getOrder() - 5);
        this.controller = controller;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.detectHandlerMethods(this.controller);
        while (this.prefix.endsWith("/")) {
            this.prefix = this.prefix.substring(0, this.prefix.length() - 1);
        }
    }

    protected void initHandlerMethods() {
    }

    protected HandlerMethod getHandlerInternal(HttpServletRequest request) throws Exception {
        Object function;
        HandlerMethod handler = super.getHandlerInternal(request);
        if (handler == null) {
            return null;
        }
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path == null) {
            return handler;
        }
        if (StringUtils.hasText((String)this.prefix) && !path.startsWith(this.prefix)) {
            return null;
        }
        if (path.startsWith(this.prefix)) {
            path = path.substring(this.prefix.length());
        }
        if ((function = FunctionWebUtils.findFunction(HttpMethod.resolve((String)request.getMethod()), this.functions, new HttpRequestAttributeDelegate(request), path)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found function for GET: " + path));
            }
            request.setAttribute(WebRequestConstants.HANDLER, function);
            return handler;
        }
        return null;
    }

    private static class HttpRequestAttributeDelegate
    extends HashMap<String, Object> {
        private final HttpServletRequest request;

        HttpRequestAttributeDelegate(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public Object put(String key, Object value) {
            this.request.setAttribute(key, value);
            return value;
        }
    }
}

