/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.util;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.web.constants.WebRequestConstants;
import org.springframework.http.HttpMethod;

public final class FunctionWebUtils {
    private FunctionWebUtils() {
    }

    public static Object findFunction(HttpMethod method, FunctionCatalog functionCatalog, Map<String, Object> attributes, String path) {
        if (method.equals((Object)HttpMethod.GET) || method.equals((Object)HttpMethod.POST)) {
            return FunctionWebUtils.doFindFunction(method, functionCatalog, attributes, path);
        }
        throw new IllegalStateException("HTTP method '" + method + "' is not supported;");
    }

    private static Object doFindFunction(HttpMethod method, FunctionCatalog functionCatalog, Map<String, Object> attributes, String path) {
        Supplier supplier;
        String string = path = path.startsWith("/") ? path.substring(1) : path;
        if (method.equals((Object)HttpMethod.GET) && (supplier = (Supplier)functionCatalog.lookup(Supplier.class, path)) != null) {
            attributes.put(WebRequestConstants.SUPPLIER, supplier);
            return supplier;
        }
        StringBuilder builder = new StringBuilder();
        String name = path;
        String value = null;
        for (String element : path.split("/")) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(element);
            name = builder.toString();
            value = path.length() > name.length() ? path.substring(name.length() + 1) : null;
            Function function = (Function)functionCatalog.lookup(Function.class, name);
            if (function == null) continue;
            attributes.put(WebRequestConstants.FUNCTION, function);
            if (value != null) {
                attributes.put(WebRequestConstants.ARGUMENT, value);
            }
            return function;
        }
        return null;
    }
}

