/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.leader;

import java.util.HashMap;
import java.util.Optional;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.cloud.kubernetes.leader.Leader;
import org.springframework.cloud.kubernetes.leader.LeadershipController;
import org.springframework.integration.leader.Candidate;

public class LeaderInfoContributor
implements InfoContributor {
    private final LeadershipController leadershipController;
    private final Candidate candidate;

    public LeaderInfoContributor(LeadershipController leadershipController, Candidate candidate) {
        this.leadershipController = leadershipController;
        this.candidate = candidate;
    }

    public void contribute(Info.Builder builder) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        Optional<Leader> leader = this.leadershipController.getLocalLeader();
        if (leader.isPresent()) {
            Leader l = leader.get();
            details.put("leaderId", l.getId());
            details.put("role", l.getRole());
            details.put("isLeader", l.isCandidate(this.candidate));
        } else {
            details.put("leaderId", "Unknown");
        }
        builder.withDetail("leaderElection", details);
    }
}

