/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.leader;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.kubernetes.leader.LeaderProperties;
import org.springframework.cloud.kubernetes.leader.LeaderRecordWatcher;
import org.springframework.cloud.kubernetes.leader.LeadershipController;
import org.springframework.cloud.kubernetes.leader.PodReadinessWatcher;
import org.springframework.context.SmartLifecycle;

public class LeaderInitiator
implements SmartLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderInitiator.class);
    private final LeaderProperties leaderProperties;
    private final LeadershipController leadershipController;
    private final LeaderRecordWatcher leaderRecordWatcher;
    private final PodReadinessWatcher hostPodWatcher;
    private ScheduledExecutorService scheduledExecutorService;
    private boolean isRunning;

    public LeaderInitiator(LeaderProperties leaderProperties, LeadershipController leadershipController, LeaderRecordWatcher leaderRecordWatcher, PodReadinessWatcher hostPodWatcher) {
        this.leaderProperties = leaderProperties;
        this.leadershipController = leadershipController;
        this.leaderRecordWatcher = leaderRecordWatcher;
        this.hostPodWatcher = hostPodWatcher;
    }

    public boolean isAutoStartup() {
        return this.leaderProperties.isAutoStartup();
    }

    public void start() {
        if (!this.isRunning()) {
            LOGGER.debug("Leader initiator starting");
            this.leaderRecordWatcher.start();
            this.hostPodWatcher.start();
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.scheduledExecutorService.scheduleAtFixedRate(this.leadershipController::update, this.leaderProperties.getUpdatePeriod().toMillis(), this.leaderProperties.getUpdatePeriod().toMillis(), TimeUnit.MILLISECONDS);
            this.isRunning = true;
        }
    }

    public void stop() {
        if (this.isRunning()) {
            LOGGER.debug("Leader initiator stopping");
            this.scheduledExecutorService.shutdown();
            this.scheduledExecutorService = null;
            this.hostPodWatcher.stop();
            this.leaderRecordWatcher.stop();
            this.leadershipController.revoke();
            this.isRunning = false;
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getPhase() {
        return 0;
    }
}

