/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.annotation;

import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SpanTag;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(classes={TestConfiguration.class})
public abstract class SleuthSpanCreatorAspectTests {
    @Autowired
    TestBeanInterface testBean;
    @Autowired
    Tracer tracer;
    @Autowired
    TestSpanHandler spans;

    @BeforeEach
    public void setup() {
        this.spans.clear();
    }

    @Test
    public void shouldCreateSpanWhenAnnotationOnInterfaceMethod() {
        this.testBean.testMethod();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method");
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void shouldCreateSpanWhenAnnotationOnClassMethod() {
        this.testBean.testMethod2();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method2");
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void shouldCreateSpanWithCustomNameWhenAnnotationOnClassMethod() {
        this.testBean.testMethod3();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method3");
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void shouldCreateSpanWithCustomNameWhenAnnotationOnInterfaceMethod() {
        this.testBean.testMethod4();
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method4");
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void shouldCreateSpanWithTagWhenAnnotationOnInterfaceMethod() {
        this.testBean.testMethod5("test");
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method5");
        BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"testTag", (Object)"test");
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void shouldCreateSpanWithTagWhenAnnotationOnClassMethod() {
        this.testBean.testMethod6("test");
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method6");
        BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"testTag6", (Object)"test");
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void shouldCreateSpanWithLogWhenAnnotationOnInterfaceMethod() {
        this.testBean.testMethod8("test");
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method8");
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void shouldCreateSpanWithLogWhenAnnotationOnClassMethod() {
        this.testBean.testMethod9("test");
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("custom-name-on-test-method9");
        ((MapAssert)BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"class", (Object)"TestBean")).containsEntry((Object)"method", (Object)"testMethod9");
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldContinueSpanWithLogWhenAnnotationOnInterfaceMethod() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            this.testBean.testMethod10("test");
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
        BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"customTestTag10", (Object)"test");
        BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void shouldStartAndCloseSpanOnContinueSpanIfSpanNotSet() {
        this.testBean.testMethod10("test");
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method10");
        BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"customTestTag10", (Object)"test");
        BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldContinueSpanWhenKeyIsUsedOnSpanTagWhenAnnotationOnInterfaceMethod() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            this.testBean.testMethod10_v2("test");
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
        BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"customTestTag10", (Object)"test");
        BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldContinueSpanWithLogWhenAnnotationOnClassMethod() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            this.testBean.testMethod11("test");
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
        ((MapAssert)((MapAssert)BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"class", (Object)"TestBean")).containsEntry((Object)"method", (Object)"testMethod11")).containsEntry((Object)"customTestTag11", (Object)"test");
        BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"customTest.before", "customTest.after"});
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void shouldAddErrorTagWhenExceptionOccurredInNewSpan() {
        try {
            this.testBean.testMethod12("test");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("test-method12");
        BDDAssertions.then((Map)this.spans.get(0).getTags()).containsEntry((Object)"testTag12", (Object)"test");
        BDDAssertions.then((Throwable)this.spans.get(0).getError()).hasMessageContaining("test exception 12");
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddErrorTagWhenExceptionOccurredInContinueSpan() {
        Span span = this.tracer.nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracer.withSpan(span.start());){
            this.testBean.testMethod13();
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Iterable)this.spans).hasSize(1);
        BDDAssertions.then((String)this.spans.get(0).getName()).isEqualTo("foo");
        BDDAssertions.then((Throwable)this.spans.get(0).getError()).hasMessageContaining("test exception 13");
        BDDAssertions.then(this.spans.get(0).getEvents().stream().map(Map.Entry::getValue).collect(Collectors.toList())).contains((Object[])new String[]{"testMethod13.before", "testMethod13.afterFailure", "testMethod13.after"});
        BDDAssertions.then((long)this.spans.get(0).getEndTimestamp()).isNotZero();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Test
    public void shouldNotCreateSpanWhenNotAnnotated() {
        this.testBean.testMethod7();
        BDDAssertions.then((Iterable)this.spans).isEmpty();
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    public static class TestConfiguration {
        @Bean
        TestBeanInterface testBean() {
            return new TestBean();
        }
    }

    protected static class TestBean
    implements TestBeanInterface {
        protected TestBean() {
        }

        @Override
        public void testMethod() {
        }

        @Override
        @NewSpan
        public void testMethod2() {
        }

        @Override
        @NewSpan(name="customNameOnTestMethod3")
        public void testMethod3() {
        }

        @Override
        public void testMethod4() {
        }

        @Override
        public void testMethod5(String test) {
        }

        @Override
        @NewSpan(name="customNameOnTestMethod6")
        public void testMethod6(@SpanTag(value="testTag6") String test) {
        }

        @Override
        public void testMethod7() {
        }

        @Override
        public void testMethod8(String param) {
        }

        @Override
        @NewSpan(name="customNameOnTestMethod9")
        public void testMethod9(String param) {
        }

        @Override
        public void testMethod10(@SpanTag(value="customTestTag10") String param) {
        }

        @Override
        public void testMethod10_v2(@SpanTag(key="customTestTag10") String param) {
        }

        @Override
        @ContinueSpan(log="customTest")
        public void testMethod11(@SpanTag(value="customTestTag11") String param) {
        }

        @Override
        public void testMethod12(String param) {
            throw new RuntimeException("test exception 12");
        }

        @Override
        public void testMethod13() {
            throw new RuntimeException("test exception 13");
        }
    }

    protected static interface TestBeanInterface {
        @NewSpan
        public void testMethod();

        public void testMethod2();

        @NewSpan(name="interfaceCustomNameOnTestMethod3")
        public void testMethod3();

        @NewSpan(value="customNameOnTestMethod4")
        public void testMethod4();

        @NewSpan(name="customNameOnTestMethod5")
        public void testMethod5(@SpanTag(value="testTag") String var1);

        public void testMethod6(String var1);

        public void testMethod7();

        @NewSpan(name="customNameOnTestMethod8")
        public void testMethod8(String var1);

        @NewSpan(name="testMethod9")
        public void testMethod9(String var1);

        @ContinueSpan(log="customTest")
        public void testMethod10(@SpanTag(value="testTag10") String var1);

        @ContinueSpan(log="customTest")
        public void testMethod10_v2(@SpanTag(value="testTag10") String var1);

        @ContinueSpan(log="testMethod11")
        public void testMethod11(@SpanTag(value="testTag11") String var1);

        @NewSpan
        public void testMethod12(@SpanTag(value="testTag12") String var1);

        @ContinueSpan(log="testMethod13")
        public void testMethod13();
    }
}

