/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.Objects;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.presentation.StandardRepresentation;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public abstract class FlowsScopePassingSpanSubscriberTests {
    AnnotationConfigApplicationContext springContext = new AnnotationConfigApplicationContext();

    protected abstract CurrentTraceContext currentTraceContext();

    protected abstract TraceContext context();

    @BeforeEach
    public void setup() {
        Hooks.resetOnEachOperator((String)"org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfiguration.TraceReactorConfiguration");
        Hooks.resetOnLastOperator((String)"org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfiguration.TraceReactorConfiguration");
        Schedulers.resetOnScheduleHooks();
    }

    @AfterEach
    public void close() {
        this.springContext.close();
    }

    @Test
    public void should_not_trace_scalar_flows() {
        this.springContext.registerBean(CurrentTraceContext.class, this::currentTraceContext, new BeanDefinitionCustomizer[0]);
        this.springContext.refresh();
        Function transformer = ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)this.springContext);
        try (CurrentTraceContext.Scope ws = this.currentTraceContext().newScope(this.context());){
            CoreSubscriber<Object> assertNoSpanSubscriber = new CoreSubscriber<Object>(){

                public void onSubscribe(Subscription s) {
                    s.request(Long.MAX_VALUE);
                    Assertions.assertThat((Object)s).isNotInstanceOf(ScopePassingSpanSubscriber.class);
                }

                public void onNext(Object o) {
                }

                public void onError(Throwable t) {
                }

                public void onComplete() {
                }
            };
            CoreSubscriber<Object> assertSpanSubscriber = new CoreSubscriber<Object>(){

                public void onSubscribe(Subscription s) {
                    s.request(Long.MAX_VALUE);
                    Assertions.assertThat((Object)s).isInstanceOf(ScopePassingSpanSubscriber.class);
                }

                public void onNext(Object o) {
                }

                public void onError(Throwable t) {
                }

                public void onComplete() {
                }
            };
            ((Publisher)transformer.apply(Mono.just((Object)1).hide())).subscribe((Subscriber)assertSpanSubscriber);
            ((Publisher)transformer.apply(Mono.just((Object)1))).subscribe((Subscriber)assertNoSpanSubscriber);
            ((Publisher)transformer.apply(Mono.error((Throwable)new Exception()).hide())).subscribe((Subscriber)assertSpanSubscriber);
            ((Publisher)transformer.apply(Mono.error((Throwable)new Exception()))).subscribe((Subscriber)assertNoSpanSubscriber);
            ((Publisher)transformer.apply(Mono.empty().hide())).subscribe((Subscriber)assertSpanSubscriber);
            ((Publisher)transformer.apply(Mono.empty())).subscribe((Subscriber)assertNoSpanSubscriber);
        }
        Awaitility.await().untilAsserted(() -> BDDAssertions.then((Object)this.currentTraceContext().context()).isNull());
    }

    static {
        StandardRepresentation.registerFormatterForType(ScopePassingSpanSubscriber.class, Objects::toString);
    }
}

