/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.BDDAssertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRequestHttpHeadersFilter;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public abstract class TraceRequestHttpHeadersFilterTests
implements TestTracingAwareSupplier {
    @Test
    public void should_override_span_tracing_headers() {
        TraceRequestHttpHeadersFilter filter = new TraceRequestHttpHeadersFilter(this.tracerTest().tracing().tracer(), this.tracerTest().tracing().httpClientHandler(), this.tracerTest().tracing().propagator());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("X-Hello", "World");
        httpHeaders.set("X-B3-TraceId", "52f112af7472aff0");
        httpHeaders.set("X-B3-SpanId", "53e6ab6fc5dfee58");
        MockServerHttpRequest request = ((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.post((String)"foo/bar", (Object[])new Object[0]).headers((MultiValueMap)httpHeaders)).build();
        MockServerWebExchange exchange = MockServerWebExchange.builder((MockServerHttpRequest)request).build();
        HttpHeaders filteredHeaders = filter.filter(this.requestHeaders(httpHeaders), (ServerWebExchange)exchange);
        BDDAssertions.then((String)this.high(filteredHeaders.get((Object)"X-B3-TraceId"))).isEqualTo(this.high(httpHeaders.get((Object)"X-B3-TraceId")));
        BDDAssertions.then((String)this.high(filteredHeaders.get((Object)"X-B3-SpanId"))).isNotEqualTo((Object)this.high(httpHeaders.get((Object)"X-B3-SpanId")));
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Hello")).isEqualTo(Collections.singletonList("World"));
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Hello-Request")).isEqualTo(Collections.singletonList("Request World"));
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Auth-User")).hasSize(1);
        BDDAssertions.then((Object)exchange.getAttribute(TraceRequestHttpHeadersFilter.SPAN_ATTRIBUTE)).isNotNull();
    }

    @Test
    public void should_override_span_tracing_headers_when_using_b3() {
        TraceRequestHttpHeadersFilter filter = new TraceRequestHttpHeadersFilter(this.tracerTest().tracing().tracer(), this.tracerTest().tracing().httpClientHandler(), this.tracerTest().tracing().propagator());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("X-Hello", "World");
        httpHeaders.set("B3", "1111111111111111-1111111111111111");
        MockServerHttpRequest request = ((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.post((String)"foo/bar", (Object[])new Object[0]).headers((MultiValueMap)httpHeaders)).build();
        MockServerWebExchange exchange = MockServerWebExchange.builder((MockServerHttpRequest)request).build();
        HttpHeaders filteredHeaders = filter.filter(this.requestHeaders(httpHeaders), (ServerWebExchange)exchange);
        BDDAssertions.then((String)this.high(filteredHeaders.get((Object)"X-B3-TraceId"))).isEqualTo(this.high(Collections.singletonList("1111111111111111")));
        BDDAssertions.then((String)this.high(filteredHeaders.get((Object)"X-B3-SpanId"))).isNotEqualTo((Object)this.high(Collections.singletonList("1111111111111111")));
        BDDAssertions.then((List)filteredHeaders.get((Object)"B3")).isNullOrEmpty();
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Hello")).isEqualTo(Collections.singletonList("World"));
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Hello-Request")).isEqualTo(Collections.singletonList("Request World"));
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Auth-User")).hasSize(1);
        BDDAssertions.then((Object)exchange.getAttribute(TraceRequestHttpHeadersFilter.SPAN_ATTRIBUTE)).isNotNull();
    }

    @Test
    public void should_set_tracing_headers() {
        TraceRequestHttpHeadersFilter filter = new TraceRequestHttpHeadersFilter(this.tracerTest().tracing().tracer(), this.tracerTest().tracing().httpClientHandler(), this.tracerTest().tracing().propagator());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("X-Hello", "World");
        MockServerHttpRequest request = ((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.post((String)"foo/bar", (Object[])new Object[0]).headers((MultiValueMap)httpHeaders)).build();
        MockServerWebExchange exchange = MockServerWebExchange.builder((MockServerHttpRequest)request).build();
        HttpHeaders filteredHeaders = filter.filter(this.requestHeaders(httpHeaders), (ServerWebExchange)exchange);
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-B3-TraceId")).isNotEmpty();
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-B3-SpanId")).isNotEmpty();
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Hello")).isEqualTo(Collections.singletonList("World"));
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Hello-Request")).isEqualTo(Collections.singletonList("Request World"));
        BDDAssertions.then((Object)exchange.getAttribute(TraceRequestHttpHeadersFilter.SPAN_ATTRIBUTE)).isNotNull();
    }

    @Test
    public void should_reuse_headers_only_from_input_since_exchange_may_contain_already_ignored_headers() {
        TraceRequestHttpHeadersFilter filter = new TraceRequestHttpHeadersFilter(this.tracerTest().tracing().tracer(), this.tracerTest().tracing().httpClientHandler(), this.tracerTest().tracing().propagator());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("X-Hello", "World");
        MockServerHttpRequest request = ((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.post((String)"foo/bar", (Object[])new Object[0]).headers((MultiValueMap)httpHeaders)).build();
        MockServerWebExchange exchange = MockServerWebExchange.builder((MockServerHttpRequest)request).build();
        HttpHeaders filteredHeaders = filter.filter(this.requestHeaders(), (ServerWebExchange)exchange);
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-B3-TraceId")).isNotEmpty();
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-B3-SpanId")).isNotEmpty();
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Hello")).isNullOrEmpty();
        BDDAssertions.then((Object)exchange.getAttribute(TraceRequestHttpHeadersFilter.SPAN_ATTRIBUTE)).isNotNull();
    }

    @Test
    public void should_set_tracing_headers_with_multiple_values() {
        TraceRequestHttpHeadersFilter filter = new TraceRequestHttpHeadersFilter(this.tracerTest().tracing().tracer(), this.tracerTest().tracing().httpClientHandler(), this.tracerTest().tracing().propagator());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("X-Hello-Request", "Request World");
        httpHeaders.addAll("X-Hello", Arrays.asList("World1", "World2"));
        MockServerHttpRequest request = ((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.post((String)"foo/bar", (Object[])new Object[0]).headers((MultiValueMap)httpHeaders)).build();
        MockServerWebExchange exchange = MockServerWebExchange.builder((MockServerHttpRequest)request).build();
        HttpHeaders filteredHeaders = filter.filter(httpHeaders, (ServerWebExchange)exchange);
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-B3-TraceId")).isNotEmpty();
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-B3-SpanId")).isNotEmpty();
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Hello")).isEqualTo(Arrays.asList("World1", "World2"));
        BDDAssertions.then((List)filteredHeaders.get((Object)"X-Hello-Request")).isEqualTo(Collections.singletonList("Request World"));
        BDDAssertions.then((Object)exchange.getAttribute(TraceRequestHttpHeadersFilter.SPAN_ATTRIBUTE)).isNotNull();
    }

    private HttpHeaders requestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("X-Hello-Request", "Request World");
        headers.add("X-Auth-User", "aaaa");
        return headers;
    }

    private HttpHeaders requestHeaders(HttpHeaders originalHeaders) {
        HttpHeaders headers = new HttpHeaders();
        headers.putAll((Map)originalHeaders);
        headers.add("X-Hello-Request", "Request World");
        headers.add("X-Auth-User", "aaaa");
        return headers;
    }

    private String high(List<String> ids) {
        ((ListAssert)BDDAssertions.then(ids).isNotNull()).isNotEmpty();
        String id = ids.get(0);
        if (id.length() == 32) {
            return id.substring(16);
        }
        return id;
    }
}

