/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.InterestResultPolicy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.util.Assert;

public class Interest<K>
implements InitializingBean {
    public static final String ALL_KEYS = "ALL_KEYS";
    protected static final boolean DEFAULT_DURABLE = false;
    protected static final boolean DEFAULT_RECEIVE_VALUES = true;
    private static final Constants constants = new Constants(InterestResultPolicy.class);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean durable = false;
    private boolean receiveValues = true;
    private InterestResultPolicy policy = InterestResultPolicy.DEFAULT;
    private K key;
    private Type type;

    public static <K> Interest newInterest(K key) {
        return new Interest<K>(key);
    }

    public Interest(K key) {
        this(key, InterestResultPolicy.DEFAULT, false, true);
    }

    public Interest(K key, InterestResultPolicy policy) {
        this(key, policy, false, true);
    }

    public Interest(K key, InterestResultPolicy policy, boolean durable) {
        this(key, policy, durable, true);
    }

    public Interest(K key, InterestResultPolicy policy, boolean durable, boolean receiveValues) {
        this.key = key;
        this.policy = policy;
        this.durable = durable;
        this.receiveValues = receiveValues;
        this.afterPropertiesSet();
    }

    @Deprecated
    public Interest(K key, String policy) {
        this(key, policy, false, true);
    }

    @Deprecated
    public Interest(K key, String policy, boolean durable) {
        this(key, policy, durable, true);
    }

    @Deprecated
    public Interest(K key, String policy, boolean durable, boolean receiveValues) {
        this(key, (InterestResultPolicy)constants.asObject(policy), durable, receiveValues);
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.key, (String)"Key is required");
        this.setType(this.resolveType(this.getType()));
    }

    protected Type resolveType(Type type) {
        return type != null ? type : (this.isRegularExpression(this.getKey()) ? Type.REGEX : Type.KEY);
    }

    protected boolean isRegularExpression(Object key) {
        return !ALL_KEYS.equals(key) && !(key instanceof List) && this.isRegularExpression(String.valueOf(key));
    }

    protected boolean isRegularExpression(String value) {
        try {
            return this.containsNonAlphaNumericWhitespace(value) && Pattern.compile(value) != null;
        }
        catch (PatternSyntaxException ignore) {
            return false;
        }
    }

    protected boolean containsNonAlphaNumericWhitespace(String value) {
        for (char character : String.valueOf(value).toCharArray()) {
            if (!this.isNotAlphaNumericWhitespace(character)) continue;
            return true;
        }
        return false;
    }

    protected boolean isNotAlphaNumericWhitespace(char character) {
        return !this.isAlphaNumericWhitespace(character);
    }

    protected boolean isAlphaNumericWhitespace(char character) {
        return Character.isDigit(character) || Character.isLetter(character) || Character.isWhitespace(character);
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public InterestResultPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Object policy) {
        if (policy instanceof InterestResultPolicy) {
            this.policy = (InterestResultPolicy)policy;
        } else if (policy instanceof String) {
            this.policy = (InterestResultPolicy)constants.asObject(String.valueOf(policy));
        } else {
            throw new IllegalArgumentException(String.format("Unknown argument type [%s] for property 'policy'", policy));
        }
    }

    public boolean isReceiveValues() {
        return this.receiveValues;
    }

    public void setReceiveValues(boolean receiveValues) {
        this.receiveValues = receiveValues;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isKeyType() {
        return Type.KEY.equals((Object)this.getType());
    }

    public boolean isRegexType() {
        return Type.REGEX.equals((Object)this.getType());
    }

    public String toString() {
        return String.format("{ @type = %1$s, key = %2$s, durable = %3$s, policy = %4$s, receiveValues = %5$s, type = %6$s }", new Object[]{this.getClass().getName(), this.getKey(), this.isDurable(), this.getPolicy(), this.isReceiveValues(), this.getType()});
    }

    public Interest asType(Type type) {
        this.setType(this.resolveType(type));
        return this;
    }

    public Interest makeDurable() {
        this.setDurable(true);
        return this;
    }

    public Interest receivesValues(boolean receiveValues) {
        this.setReceiveValues(receiveValues);
        return this;
    }

    public Interest usingPolicy(InterestResultPolicy policy) {
        this.setPolicy(policy);
        return this;
    }

    public Interest withKey(K key) {
        this.setKey(key);
        this.setType(this.resolveType(this.getType()));
        return this;
    }

    public static enum Type {
        KEY,
        REGEX;

    }
}

