/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableOffHeap;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class OffHeapConfiguration
extends EmbeddedServiceConfigurationSupport {
    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableOffHeap.class;
    }

    @Override
    protected void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, Map<String, Object> annotationAttributes, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(OffHeapBeanFactoryPostProcessor.class);
        builder.addConstructorArgValue((Object)this.resolveProperty(this.cacheOffHeapProperty("region-names"), String[].class, (String[])annotationAttributes.get("regionNames")));
        registry.registerBeanDefinition(this.generateBeanName(OffHeapBeanFactoryPostProcessor.class), (BeanDefinition)builder.getBeanDefinition());
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        return PropertiesBuilder.create().setProperty("off-heap-memory-size", this.resolveProperty(this.cacheOffHeapProperty("memory-size"), (String)annotationAttributes.get("memorySize"))).build();
    }

    protected static class OffHeapBeanFactoryPostProcessor
    extends AbstractAnnotationConfigSupport
    implements BeanFactoryPostProcessor {
        private final Set<String> regionNames;

        protected OffHeapBeanFactoryPostProcessor(Set<String> regionNames) {
            this.regionNames = CollectionUtils.nullSafeSet(regionNames);
        }

        @Override
        protected Class<? extends Annotation> getAnnotationType() {
            throw new UnsupportedOperationException("Not Implemented");
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            Arrays.stream(ArrayUtils.nullSafeArray(beanFactory.getBeanDefinitionNames(), String.class)).forEach(beanName -> Optional.of(beanFactory.getBeanDefinition(beanName)).filter(beanDefinition -> this.isTargetedRegionBean((String)beanName, (BeanDefinition)beanDefinition, beanFactory)).ifPresent(beanDefinition -> beanDefinition.getPropertyValues().addPropertyValue("offHeap", (Object)true)));
        }

        private boolean isTargetedRegionBean(String beanName, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
            return this.isNamedRegion(beanName, beanDefinition, beanFactory) && this.isRegionBean(beanDefinition, beanFactory);
        }

        private boolean isRegionBean(BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
            return Optional.ofNullable(beanDefinition).flatMap(it -> this.resolveBeanClass((BeanDefinition)it, beanFactory.getBeanClassLoader())).filter(beanClass -> RegionLookupFactoryBean.class.isAssignableFrom((Class<?>)beanClass)).isPresent();
        }

        private boolean isNamedRegion(String beanName, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
            return CollectionUtils.isEmpty(this.regionNames) || CollectionUtils.containsAny(this.regionNames, this.resolveBeanNames(beanName, beanDefinition, beanFactory));
        }

        private Collection<String> resolveBeanNames(String beanName, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
            Object regionNameValue;
            HashSet<String> beanNames = new HashSet<String>();
            beanNames.add(beanName);
            Collections.addAll(beanNames, beanFactory.getAliases(beanName));
            PropertyValue regionName = beanDefinition.getPropertyValues().getPropertyValue("regionName");
            if (regionName != null && (regionNameValue = regionName.getValue()) != null) {
                beanNames.add(regionNameValue.toString());
            }
            return beanNames;
        }
    }
}

