/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.util.Arrays;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.function.config.TypeFilterParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class XmlFunctionExecutionConfigurationSource
extends AbstractFunctionExecutionConfigurationSource {
    private static final String BASE_PACKAGE = "base-package";
    private final Element element;
    private final Iterable<TypeFilter> includeFilters;
    private final Iterable<TypeFilter> excludeFilters;
    private final ParserContext parserContext;

    public XmlFunctionExecutionConfigurationSource(Element element, ParserContext parserContext) {
        Assert.notNull((Object)element, (String)"Element must not be null");
        Assert.notNull((Object)parserContext, (String)"ParserContext must not be null");
        this.element = element;
        this.parserContext = parserContext;
        TypeFilterParser parser = new TypeFilterParser(parserContext.getReaderContext());
        this.includeFilters = parser.parseTypeFilters(element, TypeFilterParser.Type.INCLUDE);
        this.excludeFilters = parser.parseTypeFilters(element, TypeFilterParser.Type.EXCLUDE);
    }

    @Override
    public Object getSource() {
        return this.parserContext.extractSource((Object)this.element);
    }

    @Override
    public Iterable<String> getBasePackages() {
        String attribute = this.element.getAttribute(BASE_PACKAGE);
        return Arrays.asList(StringUtils.delimitedListToStringArray((String)attribute, (String)",", (String)" "));
    }

    @Override
    public Iterable<TypeFilter> getExcludeFilters() {
        return this.excludeFilters;
    }

    @Override
    public Iterable<TypeFilter> getIncludeFilters() {
        return this.includeFilters;
    }
}

