/*
 *  Copyright 2019 the original author or authors.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 *  or implied. See the License for the specific language governing
 *  permissions and limitations under the License.
 */

package org.springframework.data.gemfire.tests.support;

import java.util.concurrent.atomic.AtomicLong;

/**
 * The {@link IdentifierSequence} class is an Identifier (ID) generator generating unique IDs in sequence.
 *
 * @author John Blum
 * @see java.lang.System#currentTimeMillis()
 * @see java.util.concurrent.atomic.AtomicLong
 * @since 0.0.1
 */
@SuppressWarnings("unused")
public abstract class IdentifierSequence {

	private static final AtomicLong ID_SEQUENCE = new AtomicLong(System.currentTimeMillis());

	public static long nextId() {
		return ID_SEQUENCE.incrementAndGet();
	}
}
