/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.junit.AfterClass;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.data.gemfire.config.annotation.CacheServerApplication;
import org.springframework.data.gemfire.config.annotation.ClientCacheApplication;
import org.springframework.data.gemfire.config.annotation.EnablePdx;
import org.springframework.data.gemfire.tests.integration.ClientServerIntegrationTestsSupport;
import org.springframework.data.gemfire.tests.integration.config.ClientServerIntegrationTestsConfiguration;
import org.springframework.data.gemfire.tests.process.ProcessWrapper;
import org.springframework.data.gemfire.util.ArrayUtils;

public abstract class ForkingClientServerIntegrationTestsSupport
extends ClientServerIntegrationTestsSupport {
    private static ProcessWrapper gemfireServer;

    public static void startGemFireServer(Class<?> gemfireServerConfigurationClass, String ... arguments) throws IOException {
        int availablePort = ForkingClientServerIntegrationTestsSupport.setAndGetPoolPortProperty(ForkingClientServerIntegrationTestsSupport.setAndGetCacheServerPortProperty(ForkingClientServerIntegrationTestsSupport.findAvailablePort()));
        ArrayList<Object> argumentList = new ArrayList<Object>(Arrays.asList(ArrayUtils.nullSafeArray((Object[])arguments, String.class)));
        argumentList.add(String.format("-D%s=%d", "spring.data.gemfire.cache.server.port", availablePort));
        ForkingClientServerIntegrationTestsSupport.setGemFireServerProcess(ForkingClientServerIntegrationTestsSupport.run(gemfireServerConfigurationClass, argumentList.toArray(new String[0])));
        ForkingClientServerIntegrationTestsSupport.waitForServerToStart("localhost", availablePort);
    }

    protected static int setAndGetCacheServerPortProperty(int port) {
        System.setProperty("spring.data.gemfire.cache.server.port", String.valueOf(port));
        return port;
    }

    protected static int setAndGetPoolPortProperty(int port) {
        System.setProperty("spring.data.gemfire.pool.servers", String.format("localhost[%d]", port));
        return port;
    }

    @AfterClass
    public static void stopGemFireServer() {
        ForkingClientServerIntegrationTestsSupport.getGemFireServerProcess().ifPresent(ClientServerIntegrationTestsSupport::stop);
        ForkingClientServerIntegrationTestsSupport.setGemFireServerProcess(null);
    }

    @AfterClass
    public static void clearCacheServerPortAndPoolPortProperties() {
        System.clearProperty("spring.data.gemfire.cache.server.port");
        System.clearProperty("spring.data.gemfire.pool.servers");
    }

    protected static synchronized void setGemFireServerProcess(ProcessWrapper gemfireServerProcess) {
        gemfireServer = gemfireServerProcess;
    }

    protected static synchronized Optional<ProcessWrapper> getGemFireServerProcess() {
        return Optional.ofNullable(gemfireServer);
    }

    @EnablePdx
    @CacheServerApplication(name="ForkingClientServerIntegrationTestsSupport", logLevel="error")
    public static class BaseGemFireServerConfiguration
    extends ClientServerIntegrationTestsConfiguration {
        public static void main(String[] args) {
            AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext(new Class[]{BaseGemFireServerConfiguration.class});
            applicationContext.registerShutdownHook();
        }
    }

    @EnablePdx
    @ClientCacheApplication(logLevel="error")
    protected static class BaseGemFireClientConfiguration
    extends ClientServerIntegrationTestsConfiguration {
        protected BaseGemFireClientConfiguration() {
        }
    }
}

