/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.integration;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionService;
import org.apache.geode.distributed.Locator;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.support.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.tests.mock.GemFireMockObjectsSupport;
import org.springframework.data.gemfire.tests.util.FileUtils;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public abstract class IntegrationTestsSupport {
    protected static final boolean DEFAULT_DEBUG_GEMFIRE_QUERIES = false;
    protected static final boolean DEBUG_GEMFIRE_QUERIES = Boolean.getBoolean("spring.data.gemfire.query.debug");
    protected static final long DEFAULT_WAIT_DURATION = TimeUnit.SECONDS.toMillis(30L);
    protected static final long DEFAULT_WAIT_INTERVAL = 500L;
    protected static final String DIRECTORY_DELETE_ON_EXIT_PROPERTY = "spring.data.gemfire.test.directory.delete-on-exit";
    protected static final String GEMFIRE_LOG_FILE = "gemfire-server.log";
    protected static final String GEMFIRE_LOG_FILE_PROPERTY = "spring.data.gemfire.log.file";
    protected static final String GEMFIRE_LOG_LEVEL = "error";
    protected static final String GEMFIRE_LOG_LEVEL_PROPERTY = "spring.data.gemfire.log.level";
    protected static final String GEMFIRE_QUERY_VERBOSE_PROPERTY = "gemfire.Query.VERBOSE";
    protected static final String SYSTEM_PROPERTIES_LOG_FILE = "system-properties.log";
    protected static final String TEST_GEMFIRE_LOG_LEVEL = "error";
    private static final Predicate<String> JAVAX_NET_SSL_NAME_PREDICATE = propertyName -> String.valueOf(propertyName).toLowerCase().startsWith("javax.net.ssl");
    private static final Predicate<String> GEMFIRE_DOT_SYSTEM_PROPERTY_NAME_PREDICATE = propertyName -> String.valueOf(propertyName).toLowerCase().startsWith("gemfire");
    private static final Predicate<String> GEODE_DOT_SYSTEM_PROPERTY_NAME_PREDICATE = propertyName -> String.valueOf(propertyName).toLowerCase().startsWith("geode");
    private static final Predicate<String> SPRING_DOT_SYSTEM_PROPERTY_NAME_PREDICATE = propertyName -> String.valueOf(propertyName).toLowerCase().startsWith("spring");
    private static final Predicate<String> ALL_SYSTEM_PROPERTIES_NAME_PREDICATE = JAVAX_NET_SSL_NAME_PREDICATE.or(GEMFIRE_DOT_SYSTEM_PROPERTY_NAME_PREDICATE).or(GEODE_DOT_SYSTEM_PROPERTY_NAME_PREDICATE).or(SPRING_DOT_SYSTEM_PROPERTY_NAME_PREDICATE);

    @BeforeClass
    public static void closeAnyGemFireCacheInstanceBeforeTestExecution() {
        IntegrationTestsSupport.closeGemFireCacheWaitOnCloseEvent();
    }

    @BeforeClass
    public static void closeAnySocketConfigurationBeforeTestExecution() {
        SocketCreatorFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void closeAnySslConfigurationBeforeTestExecution() {
        Class<SSLConfigurationFactory> clazz = SSLConfigurationFactory.class;
        synchronized (SSLConfigurationFactory.class) {
            try {
                Field instance = ReflectionUtils.findField(SSLConfigurationFactory.class, (String)"instance", SSLConfigurationFactory.class);
                Optional.ofNullable(instance).ifPresent(field -> {
                    ReflectionUtils.makeAccessible((Field)field);
                    ReflectionUtils.setField((Field)field, null, null);
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }

    @BeforeClass
    public static void stopAnyGemFireLocatorBeforeTestExecution() {
        IntegrationTestsSupport.stopGemFireLocatorWaitOnStopEvent();
    }

    @Before
    public void configureQueryDebugging() {
        if (this.isQueryDebuggingEnabled()) {
            System.setProperty(GEMFIRE_QUERY_VERBOSE_PROPERTY, Boolean.TRUE.toString());
        }
    }

    @AfterClass
    public static void clearAllBeanFactoryLocators() {
        GemfireBeanFactoryLocator.clear();
    }

    @AfterClass
    public static void clearAllJavaGemFireGeodeAndSpringDotPrefixedSystemProperties() {
        List<String> allSystemPropertyNames = System.getProperties().stringPropertyNames().stream().filter(ALL_SYSTEM_PROPERTIES_NAME_PREDICATE).collect(Collectors.toList());
        allSystemPropertyNames.forEach(System::clearProperty);
    }

    @AfterClass
    public static void destroyAllGemFireMockObjects() {
        GemFireMockObjectsSupport.destroy();
    }

    @AfterClass
    public static void unregisterAllDataSerializers() {
        Arrays.stream(ArrayUtils.nullSafeArray((Object[])InternalDataSerializer.getSerializers(), DataSerializer.class)).map(DataSerializer::getId).forEach(InternalDataSerializer::unregister);
    }

    public static void closeGemFireCacheWaitOnCloseEvent() {
        IntegrationTestsSupport.closeGemFireCacheWaitOnCloseEvent(DEFAULT_WAIT_DURATION);
    }

    public static void closeGemFireCacheWaitOnCloseEvent(long duration) {
        AtomicBoolean closed = new AtomicBoolean(false);
        IntegrationTestsSupport.waitOn(() -> {
            try {
                return Optional.ofNullable(GemfireUtils.resolveGemFireCache()).filter(cache -> !closed.get()).filter(cache -> !cache.isClosed()).map(IntegrationTestsSupport::close).map(RegionService::isClosed).orElse(true);
            }
            catch (CacheClosedException ignore) {
                closed.set(true);
                return true;
            }
        }, duration);
    }

    private static GemFireCache close(GemFireCache cache) {
        return Optional.ofNullable(cache).map(it -> {
            it.close();
            return it;
        }).orElse(cache);
    }

    public static void stopGemFireLocatorWaitOnStopEvent() {
        IntegrationTestsSupport.stopGemFireLocatorWaitOnStopEvent(DEFAULT_WAIT_DURATION);
    }

    public static void stopGemFireLocatorWaitOnStopEvent(long duration) {
        AtomicBoolean locatorStopped = new AtomicBoolean(false);
        IntegrationTestsSupport.waitOn(() -> {
            try {
                return Optional.ofNullable(Locator.getLocator()).filter(it -> !locatorStopped.get()).map(IntegrationTestsSupport::stop).map(it -> {
                    locatorStopped.set(!Locator.hasLocator());
                    return it;
                }).map(it -> locatorStopped.get()).orElse(true);
            }
            catch (Exception ignore) {
                locatorStopped.set(true);
                return true;
            }
        }, duration);
    }

    private static Locator stop(Locator locator) {
        return Optional.ofNullable(locator).map(it -> {
            it.stop();
            return it;
        }).orElse(locator);
    }

    protected static String asApplicationName(Class<?> type) {
        return type.getSimpleName();
    }

    protected static String asDirectoryName(Class<?> type) {
        return String.format("%1$s-%2$s", IntegrationTestsSupport.asApplicationName(type), LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-hh-mm-ss")));
    }

    protected static File createDirectory(String pathname) {
        return IntegrationTestsSupport.createDirectory(new File(pathname));
    }

    protected static File createDirectory(File directory) {
        ((AbstractBooleanAssert)Assertions.assertThat((directory.isDirectory() || directory.mkdirs() ? 1 : 0) != 0).as(String.format("Failed to create directory [%s]", directory), new Object[0])).isTrue();
        if (IntegrationTestsSupport.isDeleteDirectoryOnExit()) {
            directory.deleteOnExit();
        }
        return directory;
    }

    protected static boolean isDeleteDirectoryOnExit() {
        return Boolean.valueOf(System.getProperty(DIRECTORY_DELETE_ON_EXIT_PROPERTY, Boolean.TRUE.toString()));
    }

    protected boolean isQueryDebuggingEnabled() {
        return DEBUG_GEMFIRE_QUERIES || this.withQueryDebugging();
    }

    protected static String getClassNameAsPath(Class type) {
        return type.getName().replaceAll("\\.", "/");
    }

    protected static String getClassNameAsPath(Object obj) {
        return IntegrationTestsSupport.getClassNameAsPath(obj.getClass());
    }

    protected static String getPackageNameAsPath(Class type) {
        return type.getPackage().getName().replaceAll("\\.", "/");
    }

    protected static String getPackageNameAsPath(Object obj) {
        return IntegrationTestsSupport.getPackageNameAsPath(obj.getClass());
    }

    protected static String getContextXmlFileLocation(Class type) {
        return IntegrationTestsSupport.getClassNameAsPath(type).concat("-context.xml");
    }

    protected static String getServerContextXmlFileLocation(Class type) {
        return IntegrationTestsSupport.getClassNameAsPath(type).concat("-server-context.xml");
    }

    protected static String logFile() {
        return IntegrationTestsSupport.logFile(GEMFIRE_LOG_FILE);
    }

    protected static String logFile(String defaultLogFilePathname) {
        return System.getProperty(GEMFIRE_LOG_FILE_PROPERTY, defaultLogFilePathname);
    }

    protected static String logLevel() {
        return IntegrationTestsSupport.logLevel("error");
    }

    protected static String logLevel(String defaultLogLevel) {
        return System.getProperty(GEMFIRE_LOG_LEVEL_PROPERTY, defaultLogLevel);
    }

    protected static void logSystemProperties() throws IOException {
        FileUtils.write(new File(SYSTEM_PROPERTIES_LOG_FILE), String.format("%s", CollectionUtils.toString((Map)System.getProperties())));
    }

    protected static boolean waitOn(Condition condition) {
        return IntegrationTestsSupport.waitOn(condition, DEFAULT_WAIT_DURATION);
    }

    protected static boolean waitOn(Condition condition, long duration) {
        return IntegrationTestsSupport.waitOn(condition, duration, 500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean waitOn(Condition condition, long duration, long interval) {
        long resolvedInterval = Math.max(Math.min(interval, duration), 1L);
        long timeout = System.currentTimeMillis() + duration;
        try {
            while (!condition.evaluate() && System.currentTimeMillis() < timeout) {
                Condition condition2 = condition;
                synchronized (condition2) {
                    TimeUnit.MILLISECONDS.timedWait(condition, resolvedInterval);
                }
            }
            return condition.evaluate();
        }
        catch (InterruptedException cause) {
            Thread.currentThread().interrupt();
        }
        return condition.evaluate();
    }

    protected void usingDeleteDirectoryOnExit(boolean delete) {
        System.setProperty(DIRECTORY_DELETE_ON_EXIT_PROPERTY, String.valueOf(delete));
    }

    protected boolean withQueryDebugging() {
        return false;
    }

    @FunctionalInterface
    protected static interface Condition {
        public boolean evaluate();
    }
}

