/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.logging.slf4j.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public class TestAppender
extends AppenderBase<ILoggingEvent>
implements Appender<ILoggingEvent> {
    private static final AtomicReference<TestAppender> INSTANCE = new AtomicReference<Object>(null);
    private static final Stack<String> logMessages = new Stack();

    public static TestAppender getInstance() {
        return Optional.ofNullable(INSTANCE.get()).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"[%s] was not properly configured", (Object[])new Object[]{TestAppender.class.getName()}));
    }

    public TestAppender() {
        INSTANCE.compareAndSet(null, this);
    }

    protected void append(ILoggingEvent event) {
        Optional.ofNullable(event).map(ILoggingEvent::getFormattedMessage).filter(StringUtils::hasText).ifPresent(logMessages::push);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lastLogMessage() {
        Stack<String> stack = logMessages;
        synchronized (stack) {
            return logMessages.empty() ? null : logMessages.pop();
        }
    }

    public void clear() {
        logMessages.clear();
    }
}

