/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.mock;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ClientSubscriptionConfig;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.cache.server.ServerMetrics;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.data.gemfire.tests.mock.MockObjectsSupport;

public abstract class CacheServerMockObjects
extends MockObjectsSupport {
    public static CacheServer mockCacheServer(String bindAddress, ClientSubscriptionConfig clientSubscriptionConfig, String hostnameForClients, long loadPollInterval, ServerLoadProbe serverLoadProbe, int maxConnections, int maxMessageCount, int maxThreads, int maxTimeBetweenPings, int messageTimeToLive, int port, boolean running, int socketBufferSize, boolean tcpNoDelay) throws Exception {
        AtomicBoolean runningState = new AtomicBoolean(running);
        CacheServer mockCacheServer = (CacheServer)Mockito.mock(CacheServer.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)mockCacheServer.getBindAddress()).thenReturn((Object)bindAddress);
        Mockito.when((Object)mockCacheServer.getHostnameForClients()).thenReturn((Object)hostnameForClients);
        Mockito.when((Object)mockCacheServer.getLoadPollInterval()).thenReturn((Object)loadPollInterval);
        Mockito.when((Object)mockCacheServer.getLoadProbe()).thenReturn((Object)serverLoadProbe);
        Mockito.when((Object)mockCacheServer.getMaxConnections()).thenReturn((Object)maxConnections);
        Mockito.when((Object)mockCacheServer.getMaximumMessageCount()).thenReturn((Object)maxMessageCount);
        Mockito.when((Object)mockCacheServer.getMaximumTimeBetweenPings()).thenReturn((Object)maxTimeBetweenPings);
        Mockito.when((Object)mockCacheServer.getMaxThreads()).thenReturn((Object)maxThreads);
        Mockito.when((Object)mockCacheServer.getMessageTimeToLive()).thenReturn((Object)messageTimeToLive);
        Mockito.when((Object)mockCacheServer.getPort()).thenReturn((Object)port);
        Mockito.when((Object)mockCacheServer.isRunning()).thenAnswer(CacheServerMockObjects.newGetter(runningState));
        Mockito.when((Object)mockCacheServer.getSocketBufferSize()).thenReturn((Object)socketBufferSize);
        Mockito.when((Object)mockCacheServer.getTcpNoDelay()).thenReturn((Object)tcpNoDelay);
        Optional.ofNullable(clientSubscriptionConfig).ifPresent(it -> Mockito.when((Object)mockCacheServer.getClientSubscriptionConfig()).thenReturn(it));
        Optional.ofNullable(serverLoadProbe).ifPresent(it -> Mockito.when((Object)mockCacheServer.getLoadProbe()).thenReturn(it));
        ((CacheServer)Mockito.doAnswer(invocation -> {
            runningState.set(true);
            Optional.ofNullable(mockCacheServer.getLoadProbe()).ifPresent(ServerLoadProbe::open);
            return null;
        }).when((Object)mockCacheServer)).start();
        ((CacheServer)Mockito.doAnswer(invocation -> {
            runningState.set(false);
            Optional.ofNullable(mockCacheServer.getLoadProbe()).ifPresent(ServerLoadProbe::close);
            return null;
        }).when((Object)mockCacheServer)).stop();
        return mockCacheServer;
    }

    public static ClientSubscriptionConfig mockClientSubscriptionConfig(int capacity, String diskStoreName, String evictionPolicy) {
        ClientSubscriptionConfig mockClientSubscriptionConfig = (ClientSubscriptionConfig)Mockito.mock(ClientSubscriptionConfig.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)mockClientSubscriptionConfig.getCapacity()).thenReturn((Object)capacity);
        Mockito.when((Object)mockClientSubscriptionConfig.getDiskStoreName()).thenReturn((Object)diskStoreName);
        Mockito.when((Object)mockClientSubscriptionConfig.getEvictionPolicy()).thenReturn((Object)evictionPolicy);
        return mockClientSubscriptionConfig;
    }

    public static ServerLoad mockServerLoad(float connectionLoad, float loadPerConnection, float loadPerSubscriptionConnection, float subscriptionConnectionLoad) {
        return new ServerLoad(connectionLoad, loadPerConnection, subscriptionConnectionLoad, loadPerSubscriptionConnection);
    }

    public static ServerLoadProbe mockServerLoadProbe() {
        return (ServerLoadProbe)Mockito.mock(ServerLoadProbe.class);
    }

    public static ServerMetrics mockServerMetrics(int clientCount, int connectionCount, int maxConnections, int subscriptionConnectionCount) {
        ServerMetrics mockServerMetrics = (ServerMetrics)Mockito.mock(ServerMetrics.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)mockServerMetrics.getClientCount()).thenReturn((Object)clientCount);
        Mockito.when((Object)mockServerMetrics.getConnectionCount()).thenReturn((Object)connectionCount);
        Mockito.when((Object)mockServerMetrics.getMaxConnections()).thenReturn((Object)maxConnections);
        Mockito.when((Object)mockServerMetrics.getSubscriptionConnectionCount()).thenReturn((Object)subscriptionConnectionCount);
        return mockServerMetrics;
    }
}

