/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.data.gemfire.tests.process.ProcessConfiguration;
import org.springframework.data.gemfire.tests.process.ProcessWrapper;
import org.springframework.data.gemfire.tests.util.FileSystemUtils;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ProcessExecutor {
    public static final File JAVA_EXE = new File(new File(FileSystemUtils.JAVA_HOME, "bin"), "java");
    public static final String JAVA_CLASSPATH = System.getProperty("java.class.path");
    protected static final String SPRING_DATA_GEMFIRE_SYSTEM_PROPERTY_PREFIX = "spring.data.gemfire.";
    protected static final String SPRING_GEMFIRE_SYSTEM_PROPERTY_PREFIX = "spring.gemfire.";

    public static ProcessWrapper launch(Class<?> type, String ... args) throws IOException {
        return ProcessExecutor.launch(FileSystemUtils.WORKING_DIRECTORY, type, args);
    }

    public static ProcessWrapper launch(File workingDirectory, Class<?> type, String ... args) throws IOException {
        return ProcessExecutor.launch(workingDirectory, JAVA_CLASSPATH, type, args);
    }

    public static ProcessWrapper launch(File workingDirectory, String classpath, Class<?> type, String ... args) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(ProcessExecutor.buildCommand(classpath, type, args)).directory(ProcessExecutor.validateDirectory(workingDirectory)).redirectErrorStream(true);
        Process process = processBuilder.start();
        ProcessWrapper processWrapper = new ProcessWrapper(process, ProcessConfiguration.create(processBuilder));
        processWrapper.register(input -> System.err.printf("[FORK] - %s%n", input));
        return processWrapper;
    }

    protected static String[] buildCommand(String classpath, Class<?> type, String ... args) {
        Assert.notNull(type, (String)"The main Java class to launch must not be null");
        ArrayList<String> command = new ArrayList<String>();
        ArrayList<String> programArguments = new ArrayList<String>(args.length);
        command.add(JAVA_EXE.getAbsolutePath());
        command.add("-server");
        command.add("-ea");
        command.add("-classpath");
        command.add(StringUtils.hasText((String)classpath) ? classpath : JAVA_CLASSPATH);
        command.addAll(ProcessExecutor.getSpringGemFireSystemProperties());
        for (String arg : (String[])ArrayUtils.nullSafeArray((Object[])args, String.class)) {
            if (ProcessExecutor.isJvmOption(arg)) {
                command.add(arg);
                continue;
            }
            if (!ProcessExecutor.isValidArgument(arg)) continue;
            programArguments.add(arg);
        }
        command.add(type.getName());
        command.addAll(programArguments);
        return command.toArray(new String[command.size()]);
    }

    protected static Collection<? extends String> getSpringGemFireSystemProperties() {
        return System.getProperties().stringPropertyNames().stream().filter(property -> property.startsWith(SPRING_DATA_GEMFIRE_SYSTEM_PROPERTY_PREFIX) || property.startsWith(SPRING_GEMFIRE_SYSTEM_PROPERTY_PREFIX)).map(property -> String.format("-D%1$s=%2$s", property, System.getProperty(property))).collect(Collectors.toList());
    }

    protected static boolean isJvmOption(String option) {
        return StringUtils.hasText((String)option) && (option.startsWith("-D") || option.startsWith("-X"));
    }

    protected static boolean isValidArgument(String argument) {
        return StringUtils.hasText((String)argument);
    }

    protected static File validateDirectory(File workingDirectory) {
        Assert.isTrue((workingDirectory != null && (workingDirectory.isDirectory() || workingDirectory.mkdirs()) ? 1 : 0) != 0, (String)String.format("Failed to create working directory [%s]", workingDirectory));
        return workingDirectory;
    }
}

