/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.data.gemfire.tests.process.PidNotFoundException;
import org.springframework.data.gemfire.tests.process.ProcessConfiguration;
import org.springframework.data.gemfire.tests.process.ProcessInputStreamListener;
import org.springframework.data.gemfire.tests.process.ProcessUtils;
import org.springframework.data.gemfire.tests.util.FileSystemUtils;
import org.springframework.data.gemfire.tests.util.FileUtils;
import org.springframework.data.gemfire.tests.util.IOUtils;
import org.springframework.data.gemfire.tests.util.ThreadUtils;
import org.springframework.data.gemfire.tests.util.ThrowableUtils;
import org.springframework.util.Assert;

public class ProcessWrapper {
    protected static final boolean DEFAULT_DAEMON_THREAD = true;
    protected static final long DEFAULT_WAIT_TIME_MILLISECONDS = TimeUnit.SECONDS.toMillis(15L);
    private final List<ProcessInputStreamListener> listeners = new CopyOnWriteArrayList<ProcessInputStreamListener>();
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final Process process;
    private final ProcessConfiguration processConfiguration;

    public ProcessWrapper(Process process, ProcessConfiguration processConfiguration) {
        Assert.notNull((Object)process, (String)"Process is required");
        Assert.notNull((Object)processConfiguration, (String)"The context and configuration meta-data providing details about the environment in which the process is running and how the process was configured and executed is required");
        this.process = process;
        this.processConfiguration = processConfiguration;
        this.init();
    }

    private void init() {
        this.newThread("Process OUT Stream Reader Thread", this.newProcessInputStreamReaderRunnable(this.process.getInputStream())).start();
        if (!this.isRedirectingErrorStream()) {
            this.newThread("Process ERR Stream Reader Thread", this.newProcessInputStreamReaderRunnable(this.process.getErrorStream())).start();
        }
    }

    private Runnable newProcessInputStreamReaderRunnable(InputStream in) {
        return () -> {
            if (this.isRunning()) {
                BufferedReader inputReader = new BufferedReader(new InputStreamReader(in));
                try {
                    String input = inputReader.readLine();
                    while (input != null) {
                        for (ProcessInputStreamListener listener : this.listeners) {
                            listener.onInput(input);
                        }
                        input = inputReader.readLine();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    IOUtils.close(inputReader);
                }
            }
        };
    }

    private Thread newThread(String name, Runnable task) {
        Assert.hasText((String)name, (String)"Thread name is required");
        Assert.notNull((Object)task, (String)"Thread task is required");
        Thread thread = new Thread(task, name);
        thread.setDaemon(true);
        thread.setPriority(5);
        return thread;
    }

    public boolean isAlive() {
        return ProcessUtils.isAlive(this.process);
    }

    public boolean isNotAlive() {
        return !this.isAlive();
    }

    public List<String> getCommand() {
        return this.processConfiguration.getCommand();
    }

    public String getCommandString() {
        return this.processConfiguration.getCommandString();
    }

    public Map<String, String> getEnvironment() {
        return this.processConfiguration.getEnvironment();
    }

    public int getPid() {
        return ProcessUtils.findAndReadPid(this.getWorkingDirectory());
    }

    public int safeGetPid() {
        try {
            return this.getPid();
        }
        catch (PidNotFoundException ignore) {
            return -1;
        }
    }

    public boolean isRedirectingErrorStream() {
        return this.processConfiguration.isRedirectingErrorStream();
    }

    public boolean isNotRunning() {
        return !this.isRunning();
    }

    public boolean isRunning() {
        return ProcessUtils.isRunning(this.process);
    }

    public File getWorkingDirectory() {
        return this.processConfiguration.getWorkingDirectory();
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public int safeExitValue() {
        try {
            return this.exitValue();
        }
        catch (IllegalThreadStateException ignore) {
            return -1;
        }
    }

    public String readLogFile() throws IOException {
        File[] logFiles = FileSystemUtils.listFiles(this.getWorkingDirectory(), path -> path != null && (path.isDirectory() || path.getAbsolutePath().endsWith(".log")));
        if (logFiles.length > 0) {
            return this.readLogFile(logFiles[0]);
        }
        throw new FileNotFoundException(String.format("No log files found in process's [%d] working directory [%s]", this.safeGetPid(), this.getWorkingDirectory()));
    }

    public String readLogFile(File log) throws IOException {
        return FileUtils.read(log);
    }

    public boolean register(ProcessInputStreamListener listener) {
        return listener != null && this.listeners.add(listener);
    }

    public void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    public void signal() {
        block2: {
            try {
                OutputStream outputStream = this.process.getOutputStream();
                outputStream.write("\n".getBytes());
                outputStream.flush();
            }
            catch (IOException cause) {
                this.log.warning("Failed to signal process");
                if (!this.log.isLoggable(Level.FINE)) break block2;
                this.log.fine(ThrowableUtils.toString(cause));
            }
        }
    }

    public void signalStop() {
        block2: {
            try {
                ProcessUtils.signalStop(this.process);
            }
            catch (IOException cause) {
                this.log.warning("Failed to signal the process to stop");
                if (!this.log.isLoggable(Level.FINE)) break block2;
                this.log.fine(ThrowableUtils.toString(cause));
            }
        }
    }

    public int stop() {
        return this.stop(DEFAULT_WAIT_TIME_MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stop(long milliseconds) {
        if (this.isRunning()) {
            boolean interrupted = false;
            int exitValue = -1;
            int pid = this.safeGetPid();
            long timeout = System.currentTimeMillis() + milliseconds;
            AtomicBoolean exited = new AtomicBoolean(false);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            try {
                Future<Integer> futureExitValue = executorService.submit(() -> {
                    this.process.destroy();
                    int localExitValue = this.process.waitFor();
                    exited.set(true);
                    return localExitValue;
                });
                while (!exited.get() && System.currentTimeMillis() < timeout) {
                    try {
                        exitValue = futureExitValue.get(milliseconds, TimeUnit.MILLISECONDS);
                        this.log.info(String.format("Process [%s] has stopped%n", pid));
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                    }
                }
            }
            catch (TimeoutException cause) {
                exitValue = -1;
                this.log.warning(String.format("Process [%1$d] did not stop within the allotted timeout of %2$d seconds%n", pid, TimeUnit.MILLISECONDS.toSeconds(milliseconds)));
            }
            catch (Exception exception) {
            }
            finally {
                executorService.shutdownNow();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            return exitValue;
        }
        return this.exitValue();
    }

    public int shutdown() {
        if (this.isRunning()) {
            this.log.info(String.format("Stopping process [%d]...%n", this.safeGetPid()));
            this.signalStop();
            this.waitFor();
        }
        return this.stop();
    }

    public boolean unregister(ProcessInputStreamListener listener) {
        return this.listeners.remove(listener);
    }

    public void waitFor() {
        this.waitFor(DEFAULT_WAIT_TIME_MILLISECONDS);
    }

    public void waitFor(long milliseconds) {
        ThreadUtils.timedWait(milliseconds, 500L, this::isRunning);
    }
}

