/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.data.gemfire.tests.util.ThrowableUtils;

public abstract class IOUtils {
    protected static final Logger log = Logger.getLogger(IOUtils.class.getName());

    public static boolean close(Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                    return true;
                }
                catch (IOException cause) {
                    if (!log.isLoggable(Level.FINE)) break block3;
                    log.fine(String.format("Failed to close the Closeable object (%1$s) due to an I/O error:%n%2$s", closeable, ThrowableUtils.toString(cause)));
                }
            }
        }
        return false;
    }

    public static boolean doSafeIo(IoExceptionThrowingOperation operation) {
        try {
            operation.doIo();
            return true;
        }
        catch (IOException cause) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserializeObject(byte[] objectBytes) throws IOException, ClassNotFoundException {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(objectBytes);
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            IOUtils.close(objectInputStream);
            throw throwable;
        }
        IOUtils.close(objectInputStream);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeObject(Serializable obj) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(obj);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.close(objectOutputStream);
            throw throwable;
        }
        IOUtils.close(objectOutputStream);
        return byArray;
    }

    public static interface IoExceptionThrowingOperation {
        public void doIo() throws IOException;
    }
}

