/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.shiro.util.Assert;
import org.springframework.data.gemfire.tests.util.ByteArrayComparator;
import org.springframework.data.gemfire.tests.util.IOUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;

public class ObjectToByteArrayComparator
implements Comparator<Object> {
    public static final ObjectToByteArrayComparator INSTANCE = new ObjectToByteArrayComparator();

    @Override
    public int compare(Object objectOne, Object objectTwo) {
        return ByteArrayComparator.INSTANCE.compare(this.fromSerializableToByteArray(objectOne), this.fromSerializableToByteArray(objectTwo));
    }

    private Serializable assertSerializable(Object target) {
        Assert.isInstanceOf(Serializable.class, (Object)target);
        return (Serializable)target;
    }

    private byte[] fromSerializableToByteArray(Object target) {
        return this.toByteArray(this.assertSerializable(target));
    }

    private byte[] toByteArray(Object target) {
        try {
            return IOUtils.serializeObject(this.assertSerializable(target));
        }
        catch (IOException cause) {
            throw RuntimeExceptionFactory.newIllegalArgumentException((Throwable)cause, (String)"Object [%s] could not be serialized", (Object[])new Object[]{target});
        }
    }
}

