/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.util;

import java.util.concurrent.TimeUnit;

public abstract class ThreadUtils {
    public static boolean sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
            return true;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static boolean timedWait(long duration) {
        return ThreadUtils.timedWait(duration, duration);
    }

    public static boolean timedWait(long duration, long interval) {
        return ThreadUtils.timedWait(duration, interval, () -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean timedWait(long duration, long interval, WaitCondition waitCondition) {
        long timeout = System.currentTimeMillis() + duration;
        interval = Math.min(interval, duration);
        try {
            while (waitCondition.waiting() && System.currentTimeMillis() < timeout) {
                WaitCondition waitCondition2 = waitCondition;
                synchronized (waitCondition2) {
                    TimeUnit.MILLISECONDS.timedWait(waitCondition, interval);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (waitCondition.waiting()) return false;
        return true;
    }

    public static interface WaitCondition {
        public boolean waiting();
    }
}

