/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.data.neo4j.rest.PropertiesMap;

public class JsonHelper {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Map<String, Object> jsonToMap(String json) {
        return (Map)JsonHelper.readJson(json);
    }

    public static List<Map<String, Object>> jsonToListOfRelationshipRepresentations(String json) {
        return (List)JsonHelper.readJson(json);
    }

    public static Object readJson(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readValue(json, Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object jsonToSingleValue(String json) {
        Object jsonObject = JsonHelper.readJson(json);
        return jsonObject instanceof Collection ? jsonObject : PropertiesMap.assertSupportedPropertyValue(jsonObject);
    }

    public static String createJsonFrom(Object data) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = OBJECT_MAPPER.getJsonFactory().createJsonGenerator((Writer)writer).useDefaultPrettyPrinter();
            OBJECT_MAPPER.writeValue(generator, data);
            writer.close();
            return writer.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

