/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.neo4j.conversion.ConvertedResult;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.Handler;
import org.springframework.data.neo4j.conversion.QueryResult;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.rest.JsonHelper;
import org.springframework.data.neo4j.rest.RequestResult;
import org.springframework.data.neo4j.rest.RestEntityExtractor;
import org.springframework.data.neo4j.rest.RestGraphDatabase;
import org.springframework.data.neo4j.rest.RestRequest;
import org.springframework.data.neo4j.rest.RestTableResultExtractor;
import org.springframework.data.neo4j.support.query.QueryEngine;

public class RestCypherQueryEngine
implements QueryEngine<Map<String, Object>> {
    private final RestRequest restRequest;
    private final RestGraphDatabase restGraphDatabase;
    private final ResultConverter resultConverter;

    public RestCypherQueryEngine(RestGraphDatabase restGraphDatabase) {
        this(restGraphDatabase, null);
    }

    public RestCypherQueryEngine(RestGraphDatabase restGraphDatabase, ResultConverter resultConverter) {
        this.restGraphDatabase = restGraphDatabase;
        this.resultConverter = resultConverter != null ? resultConverter : new DefaultConverter();
        this.restRequest = restGraphDatabase.getRestRequest();
    }

    public QueryResult<Map<String, Object>> query(String statement, Map<String, Object> params) {
        String parametrizedStatement = QueryResultBuilder.replaceParams((String)statement, params);
        RequestResult requestResult = this.restRequest.get("ext/CypherPlugin/graphdb/execute_query", JsonHelper.createJsonFrom(MapUtil.map((Object[])new Object[]{"query", parametrizedStatement})));
        return new RestQueryResult(this.restRequest.toMap(requestResult), this.restGraphDatabase, this.resultConverter);
    }

    static class RestQueryResult
    implements QueryResult<Map<String, Object>> {
        QueryResultBuilder<Map<String, Object>> result;

        public <R> ConvertedResult<R> to(Class<R> type) {
            return this.result.to(type);
        }

        public <R> ConvertedResult<R> to(Class<R> type, ResultConverter<Map<String, Object>, R> converter) {
            return this.result.to(type, converter);
        }

        public void handle(Handler<Map<String, Object>> handler) {
            this.result.handle(handler);
        }

        public Iterator<Map<String, Object>> iterator() {
            return this.result.iterator();
        }

        public RestQueryResult(Map<?, ?> result, RestGraphDatabase restGraphDatabase, ResultConverter resultConverter) {
            RestTableResultExtractor extractor = new RestTableResultExtractor(new RestEntityExtractor(restGraphDatabase));
            List<Map<String, Object>> data = extractor.extract(result);
            this.result = new QueryResultBuilder(data, resultConverter);
        }
    }
}

