/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.collection.IterableWrapper;
import org.springframework.data.neo4j.rest.JsonHelper;
import org.springframework.data.neo4j.rest.PropertiesMap;
import org.springframework.data.neo4j.rest.RequestResult;
import org.springframework.data.neo4j.rest.RestGraphDatabase;
import org.springframework.data.neo4j.rest.RestRequest;
import org.springframework.data.neo4j.rest.util.ArrayConverter;

public class RestEntity
implements PropertyContainer {
    private Map<?, ?> structuralData;
    private Map<String, Object> propertyData;
    private long lastTimeFetchedPropertyData;
    private RestGraphDatabase graphDatabase;
    protected RestRequest restRequest;
    private final ArrayConverter arrayConverter = new ArrayConverter();

    public RestEntity(URI uri, RestGraphDatabase graphDatabase) {
        this(uri.toString(), graphDatabase);
    }

    public RestEntity(String uri, RestGraphDatabase graphDatabase) {
        this.restRequest = graphDatabase.getRestRequest().with(uri);
        this.graphDatabase = graphDatabase;
    }

    public RestEntity(Map<?, ?> data, RestGraphDatabase graphDatabase) {
        this.structuralData = data;
        this.graphDatabase = graphDatabase;
        this.propertyData = (Map)data.get("data");
        this.lastTimeFetchedPropertyData = System.currentTimeMillis();
        String uri = (String)data.get("self");
        this.restRequest = graphDatabase.getRestRequest().with(uri);
    }

    public String getUri() {
        return this.restRequest.getUri().toString();
    }

    Map<?, ?> getStructuralData() {
        if (this.structuralData == null) {
            this.structuralData = this.restRequest.toMap(this.restRequest.get(""));
        }
        return this.structuralData;
    }

    Map<String, Object> getPropertyData() {
        if (this.propertyData == null || this.timeElapsed(this.lastTimeFetchedPropertyData, this.graphDatabase.getPropertyRefetchTimeInMillis())) {
            RequestResult requestResult = this.restRequest.get("properties");
            boolean ok = this.restRequest.statusIs(requestResult, (Response.StatusType)Response.Status.OK);
            this.propertyData = ok ? this.restRequest.toMap(requestResult) : Collections.emptyMap();
            this.lastTimeFetchedPropertyData = System.currentTimeMillis();
        }
        return this.propertyData;
    }

    private boolean timeElapsed(long since, long isItGreaterThanThis) {
        return System.currentTimeMillis() - since > isItGreaterThanThis;
    }

    public Object getProperty(String key) {
        Object value = this.getPropertyValue(key);
        if (value == null) {
            throw new NotFoundException("'" + key + "' on " + this);
        }
        return value;
    }

    private Object getPropertyValue(String key) {
        Map<String, Object> properties = this.getPropertyData();
        Object value = properties.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            if (col.isEmpty()) {
                return new String[0];
            }
            Object result = this.arrayConverter.toArray(col);
            if (result == null) {
                throw new IllegalStateException("Could not determine type of property " + key);
            }
            properties.put(key, result);
            return result;
        }
        return PropertiesMap.assertSupportedPropertyValue(value);
    }

    public Object getProperty(String key, Object defaultValue) {
        Object value = this.getPropertyValue(key);
        return value != null ? value : defaultValue;
    }

    public Iterable<String> getPropertyKeys() {
        return new IterableWrapper(this.getPropertyData().keySet()){

            protected String underlyingObjectToObject(Object key) {
                return key.toString();
            }
        };
    }

    public Iterable<Object> getPropertyValues() {
        return this.getPropertyData().values();
    }

    public boolean hasProperty(String key) {
        return this.getPropertyData().containsKey(key);
    }

    public Object removeProperty(String key) {
        Object value = this.getProperty(key, null);
        this.restRequest.delete("properties/" + key);
        this.invalidatePropertyData();
        return value;
    }

    public void setProperty(String key, Object value) {
        this.restRequest.put("properties/" + key, JsonHelper.createJsonFrom(value));
        this.invalidatePropertyData();
    }

    private void invalidatePropertyData() {
        this.propertyData = null;
    }

    static long getEntityId(String uri) {
        return Long.parseLong(uri.substring(uri.lastIndexOf(47) + 1));
    }

    public long getId() {
        return RestEntity.getEntityId(this.getUri());
    }

    public void delete() {
        this.restRequest.delete("");
    }

    public int hashCode() {
        return (int)this.getId();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.getClass().equals(o.getClass()) && this.getId() == ((RestEntity)o).getId();
    }

    public GraphDatabaseService getGraphDatabase() {
        throw new UnsupportedOperationException("No GraphDatabaseService semantics for the REST-API");
    }

    public RestGraphDatabase getRestGraphDatabase() {
        return this.graphDatabase;
    }

    public RestRequest getRestRequest() {
        return this.restRequest;
    }

    public String toString() {
        return this.getUri();
    }
}

