/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.util.Map;
import org.springframework.data.neo4j.rest.RestEntity;
import org.springframework.data.neo4j.rest.RestGraphDatabase;
import org.springframework.data.neo4j.rest.RestNode;
import org.springframework.data.neo4j.rest.RestRelationship;

public class RestEntityExtractor {
    private final RestGraphDatabase restGraphDatabase;

    public RestEntityExtractor(RestGraphDatabase restGraphDatabase) {
        this.restGraphDatabase = restGraphDatabase;
    }

    Object convertFromRepresentation(Object value) {
        RestEntity restEntity;
        if (value instanceof Map && (restEntity = this.createRestEntity((Map)value)) != null) {
            return restEntity;
        }
        return value;
    }

    RestEntity createRestEntity(Map data) {
        String uri = (String)data.get("self");
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        if (uri.contains("/node/")) {
            return new RestNode(data, this.restGraphDatabase);
        }
        if (uri.contains("/relationship/")) {
            return new RestRelationship(data, this.restGraphDatabase);
        }
        return null;
    }
}

