/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.annotation.QueryType;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.rest.JsonHelper;
import org.springframework.data.neo4j.rest.RequestResult;
import org.springframework.data.neo4j.rest.RestCypherQueryEngine;
import org.springframework.data.neo4j.rest.RestGremlinQueryEngine;
import org.springframework.data.neo4j.rest.RestNode;
import org.springframework.data.neo4j.rest.RestRelationship;
import org.springframework.data.neo4j.rest.RestRequest;
import org.springframework.data.neo4j.rest.RestTraversal;
import org.springframework.data.neo4j.rest.index.RestIndexManager;
import org.springframework.data.neo4j.support.query.ConversionServiceQueryResultConverter;
import org.springframework.data.neo4j.support.query.QueryEngine;

public class RestGraphDatabase
implements GraphDatabaseService,
GraphDatabase {
    private RestRequest restRequest;
    private long propertyRefetchTimeInMillis = 1000L;
    private ConversionService conversionService;

    public RestGraphDatabase(URI uri) {
        this.restRequest = new RestRequest(uri);
    }

    public RestGraphDatabase(URI uri, String user, String password) {
        this.restRequest = new RestRequest(uri, user, password);
    }

    public Node getNodeById(long id) {
        RequestResult requestResult = this.restRequest.get("node/" + id);
        if (this.restRequest.statusIs(requestResult, (Response.StatusType)Response.Status.NOT_FOUND)) {
            throw new NotFoundException("" + id);
        }
        return new RestNode(this.restRequest.toMap(requestResult), this);
    }

    public Node createNode(Map<String, Object> props) {
        RequestResult requestResult = this.restRequest.post("node", JsonHelper.createJsonFrom(props));
        if (this.restRequest.statusOtherThan(requestResult, (Response.StatusType)Response.Status.CREATED)) {
            int status = requestResult.getStatus();
            throw new RuntimeException("" + status);
        }
        URI location = requestResult.getLocation();
        return new RestNode(location, this);
    }

    public Relationship getRelationshipById(long id) {
        RequestResult requestResult = this.restRequest.get("relationship/" + id);
        if (this.restRequest.statusIs(requestResult, (Response.StatusType)Response.Status.NOT_FOUND)) {
            throw new NotFoundException("" + id);
        }
        return new RestRelationship(this.restRequest.toMap(requestResult), this);
    }

    public Relationship createRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> props) {
        return RestRelationship.create((RestNode)startNode, (RestNode)endNode, type, props);
    }

    public <T extends PropertyContainer> Index<T> getIndex(String indexName) {
        RestIndexManager index = this.index();
        if (index.existsForNodes(indexName)) {
            return index.forNodes(indexName);
        }
        if (index.existsForRelationships(indexName)) {
            return index.forRelationships(indexName);
        }
        throw new IllegalArgumentException("Index " + indexName + " does not yet exist");
    }

    public <T extends PropertyContainer> Index<T> createIndex(Class<T> type, String indexName, boolean fullText) {
        if (Node.class.isAssignableFrom(type)) {
            return this.index().forNodes(indexName);
        }
        if (Relationship.class.isAssignableFrom(type)) {
            return this.index().forRelationships(indexName);
        }
        throw new IllegalArgumentException("Required Node or Relationship types to create index, got " + type);
    }

    public TraversalDescription createTraversalDescription() {
        return new RestTraversal();
    }

    public QueryEngine queryEngineFor(QueryType type) {
        switch (type) {
            case Cypher: {
                return new RestCypherQueryEngine(this, this.createResultConverter());
            }
            case Gremlin: {
                return new RestGremlinQueryEngine(this, this.createResultConverter());
            }
        }
        throw new IllegalArgumentException("Unknown Query Engine Type " + type);
    }

    private ResultConverter createResultConverter() {
        if (this.conversionService == null) {
            return null;
        }
        return new ConversionServiceQueryResultConverter(this.conversionService);
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public RestIndexManager index() {
        return new RestIndexManager(this.restRequest, this);
    }

    public Node getReferenceNode() {
        Map<?, ?> map = this.restRequest.toMap(this.restRequest.get(""));
        return new RestNode((String)map.get("reference_node"), this);
    }

    public RestRequest getRestRequest() {
        return this.restRequest;
    }

    public long getPropertyRefetchTimeInMillis() {
        return this.propertyRefetchTimeInMillis;
    }

    public Node createNode() {
        return this.createNode(null);
    }

    public Iterable<Node> getAllNodes() {
        throw new UnsupportedOperationException();
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() {
    }

    public Transaction beginTx() {
        return new Transaction(){

            public void failure() {
            }

            public void success() {
            }

            public void finish() {
            }
        };
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return handler;
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return handler;
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return handler;
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return handler;
    }
}

