/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.data.neo4j.conversion.ConvertedResult;
import org.springframework.data.neo4j.conversion.DefaultConverter;
import org.springframework.data.neo4j.conversion.Handler;
import org.springframework.data.neo4j.conversion.QueryResult;
import org.springframework.data.neo4j.conversion.QueryResultBuilder;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.rest.JsonHelper;
import org.springframework.data.neo4j.rest.RequestResult;
import org.springframework.data.neo4j.rest.RestEntityExtractor;
import org.springframework.data.neo4j.rest.RestGraphDatabase;
import org.springframework.data.neo4j.rest.RestRequest;
import org.springframework.data.neo4j.rest.RestResultException;
import org.springframework.data.neo4j.rest.RestTableResultExtractor;
import org.springframework.data.neo4j.support.query.QueryEngine;

public class RestGremlinQueryEngine
implements QueryEngine<Object> {
    private final RestRequest restRequest;
    private final RestGraphDatabase restGraphDatabase;
    private final ResultConverter resultConverter;

    public RestGremlinQueryEngine(RestGraphDatabase restGraphDatabase) {
        this(restGraphDatabase, null);
    }

    public RestGremlinQueryEngine(RestGraphDatabase restGraphDatabase, ResultConverter resultConverter) {
        this.restGraphDatabase = restGraphDatabase;
        this.resultConverter = resultConverter != null ? resultConverter : new DefaultConverter();
        this.restRequest = restGraphDatabase.getRestRequest();
    }

    public QueryResult<Object> query(String statement, Map<String, Object> params) {
        String data = JsonHelper.createJsonFrom(MapUtil.map((Object[])new Object[]{"script", statement, "params", params}));
        RequestResult requestResult = this.restRequest.get("ext/GremlinPlugin/graphdb/execute_script", data);
        Object result = JsonHelper.readJson(requestResult.getEntity());
        if (requestResult.getStatus() == 500) {
            return this.handleError(result);
        }
        return new RestQueryResult<Object>(result, this.restGraphDatabase, this.resultConverter);
    }

    private QueryResult<Object> handleError(Object result) {
        Map mapResult;
        if (result instanceof Map && RestResultException.isExceptionResult(mapResult = (Map)result)) {
            throw new RestResultException(mapResult);
        }
        throw new RestResultException(Collections.singletonMap("exception", result.toString()));
    }

    static class RestQueryResult<T>
    implements QueryResult<T> {
        QueryResultBuilder<T> result;
        private final RestGraphDatabase restGraphDatabase;

        public <R> ConvertedResult<R> to(Class<R> type) {
            return this.result.to(type);
        }

        public <R> ConvertedResult<R> to(Class<R> type, ResultConverter<T, R> converter) {
            return this.result.to(type, converter);
        }

        public void handle(Handler<T> handler) {
            this.result.handle(handler);
        }

        public Iterator<T> iterator() {
            return this.result.iterator();
        }

        public RestQueryResult(Object result, RestGraphDatabase restGraphDatabase, ResultConverter resultConverter) {
            this.restGraphDatabase = restGraphDatabase;
            Iterable<T> convertedResult = this.convertRestResult(result);
            this.result = new QueryResultBuilder(convertedResult, resultConverter);
        }

        private Iterable<T> convertRestResult(Object result) {
            final RestEntityExtractor restEntityExtractor = new RestEntityExtractor(this.restGraphDatabase);
            if (result instanceof Map) {
                Map mapResult = (Map)result;
                if (RestResultException.isExceptionResult(mapResult)) {
                    throw new RestResultException(mapResult);
                }
                if (RestQueryResult.isTableResult(mapResult)) {
                    return new RestTableResultExtractor(restEntityExtractor).extract(mapResult);
                }
            }
            if (result instanceof Iterable) {
                return new IterableWrapper<T, Object>((Iterable)result){

                    protected T underlyingObjectToObject(Object value) {
                        return restEntityExtractor.convertFromRepresentation(value);
                    }
                };
            }
            return Collections.singletonList(restEntityExtractor.convertFromRepresentation(result));
        }

        public static boolean isTableResult(Map<?, ?> mapResult) {
            return mapResult.containsKey("columns") && mapResult.containsKey("data");
        }
    }
}

