/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.rest;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.rest.RequestResult;
import org.springframework.data.neo4j.rest.RestEntity;
import org.springframework.data.neo4j.rest.RestGraphDatabase;
import org.springframework.data.neo4j.rest.RestRelationship;

public class RestNode
extends RestEntity
implements Node {
    public RestNode(URI uri, RestGraphDatabase graphDatabase) {
        super(uri, graphDatabase);
    }

    public RestNode(String uri, RestGraphDatabase graphDatabase) {
        super(uri, graphDatabase);
    }

    public RestNode(Map<?, ?> data, RestGraphDatabase graphDatabase) {
        super(data, graphDatabase);
    }

    public Relationship createRelationshipTo(Node toNode, RelationshipType type) {
        return RestRelationship.create(this, (RestNode)toNode, type, null);
    }

    public Iterable<Relationship> getRelationships() {
        return this.wrapRelationships(this.restRequest.get("relationships/all"));
    }

    private Iterable<Relationship> wrapRelationships(RequestResult requestResult) {
        return new IterableWrapper<Relationship, Object>((Iterable)((Collection)this.restRequest.toEntity(requestResult))){

            protected Relationship underlyingObjectToObject(Object data) {
                return new RestRelationship((Map)data, RestNode.this.getRestGraphDatabase());
            }
        };
    }

    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        String path = this.getStructuralData().get("all_relationships") + "/";
        int counter = 0;
        for (RelationshipType type : types) {
            if (counter++ > 0) {
                path = path + "&";
            }
            path = path + type.name();
        }
        return this.wrapRelationships(this.restRequest.get(path));
    }

    public Iterable<Relationship> getRelationships(Direction direction) {
        return this.wrapRelationships(this.restRequest.get("relationships/" + RestDirection.from((Direction)direction).pathName));
    }

    public Iterable<Relationship> getRelationships(final Direction direction, RelationshipType ... types) {
        return new CombiningIterable((Iterable)new IterableWrapper<Iterable<Relationship>, RelationshipType>(Arrays.asList(types)){

            protected Iterable<Relationship> underlyingObjectToObject(RelationshipType relationshipType) {
                return RestNode.this.getRelationships(relationshipType, direction);
            }
        });
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        for (RelationshipType relationshipType : types) {
            if (!this.hasRelationship(relationshipType, direction)) continue;
            return true;
        }
        return false;
    }

    public Iterable<Relationship> getRelationships(RelationshipType type, Direction direction) {
        Object relationship = this.getStructuralData().get(this.directionParameter(direction));
        return this.wrapRelationships(this.restRequest.get(relationship + "/" + type.name()));
    }

    private String directionParameter(Direction direction) {
        return RestDirection.from((Direction)direction).dataName + "_relationships";
    }

    public Relationship getSingleRelationship(RelationshipType type, Direction direction) {
        return (Relationship)IteratorUtil.singleOrNull(this.getRelationships(type, direction));
    }

    public boolean hasRelationship() {
        return this.getRelationships().iterator().hasNext();
    }

    public boolean hasRelationship(RelationshipType ... types) {
        return this.getRelationships(types).iterator().hasNext();
    }

    public boolean hasRelationship(Direction direction) {
        return this.getRelationships(direction).iterator().hasNext();
    }

    public boolean hasRelationship(RelationshipType type, Direction direction) {
        return this.getRelationships(type, direction).iterator().hasNext();
    }

    public Traverser traverse(Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... rels) {
        throw new UnsupportedOperationException();
    }

    public Traverser traverse(Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType type, Direction direction) {
        throw new UnsupportedOperationException();
    }

    public Traverser traverse(Traverser.Order order, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType type, Direction direction, RelationshipType secondType, Direction secondDirection) {
        throw new UnsupportedOperationException();
    }

    static enum RestDirection {
        INCOMING(Direction.INCOMING, "incoming", "in"),
        OUTGOING(Direction.OUTGOING, "outgoing", "out"),
        BOTH(Direction.BOTH, "all", "all");

        public final Direction direction;
        public final String dataName;
        public final String pathName;

        private RestDirection(Direction direction, String dataName, String pathName) {
            this.direction = direction;
            this.dataName = dataName;
            this.pathName = pathName;
        }

        static RestDirection from(Direction direction) {
            for (RestDirection restDirection : RestDirection.values()) {
                if (restDirection.direction != direction) continue;
                return restDirection;
            }
            throw new RuntimeException("No Rest-Direction for " + direction);
        }
    }
}

